/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.mock.servlet.MockServletRequestImpl;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.ServletExternalContextUtil;

public class ServletExternalContextUtilTest
extends TeedaTestCase {
    public void testSetCharacterEncoding() {
        MockHttpServletRequest request = this.getRequest();
        request.addHeader("Content-Type", "text/html; charset=Windows-31J");
        ServletExternalContextUtil.setCharacterEncoding((ServletRequest)request);
        ServletExternalContextUtilTest.assertEquals((String)"Windows-31J", (String)request.getCharacterEncoding());
        MockServletRequestImpl request2 = new MockServletRequestImpl((ServletContext)this.getServletContext(), "/");
        ServletExternalContextUtil.setCharacterEncoding((ServletRequest)request2);
        ServletExternalContextUtilTest.assertEquals((String)"ISO-8859-1", (String)request2.getCharacterEncoding());
    }

    public void testSetCharacterEncoding2() {
        MockHttpServletResponse response = this.getResponse();
        response.setContentType("text/html; charset=Windows-31J");
        boolean b = ServletExternalContextUtil.setCharacterEncoding((ServletResponse)response);
        ServletExternalContextUtilTest.assertTrue((boolean)b);
        ServletExternalContextUtilTest.assertEquals((String)"Windows-31J", (String)response.getCharacterEncoding());
    }

    public void testIsHttpServletRequest() {
        ServletExternalContextUtilTest.assertTrue((boolean)ServletExternalContextUtil.isHttpServletRequest((ServletRequest)new EmptyHttpServletRequest()));
        ServletExternalContextUtilTest.assertFalse((boolean)ServletExternalContextUtil.isHttpServletRequest((ServletRequest)new EmptyServletRequest()));
        ServletExternalContextUtilTest.assertFalse((boolean)ServletExternalContextUtil.isHttpServletRequest(null));
    }

    public void testIsHttpServeltResponse() {
        ServletExternalContextUtilTest.assertTrue((boolean)ServletExternalContextUtil.isHttpServletResponse((ServletResponse)new EmptyHttpServletResponse()));
        ServletExternalContextUtilTest.assertFalse((boolean)ServletExternalContextUtil.isHttpServletResponse((ServletResponse)new EmptyServletResponse()));
        ServletExternalContextUtilTest.assertFalse((boolean)ServletExternalContextUtil.isHttpServletResponse(null));
    }

    public void testGetEncodingFromContentType() {
        ServletExternalContextUtilTest.assertEquals((String)"Windows-31J", (String)ServletExternalContextUtil.getEncodingFromContentType((String)"text/html; charset=Windows-31J"));
        ServletExternalContextUtilTest.assertEquals((String)"Windows-31J", (String)ServletExternalContextUtil.getEncodingFromContentType((String)"text/html;charset=Windows-31J"));
        ServletExternalContextUtilTest.assertNull((Object)ServletExternalContextUtil.getEncodingFromContentType((String)"text/html;"));
    }

    public void testGetEncodingFromSession() {
        MockHttpServletRequest request = this.getRequest();
        HttpSession session = request.getSession(true);
        session.setAttribute("javax.faces.request.charset", (Object)"Windows-31J");
        String encoding = ServletExternalContextUtil.getEncodingFromSession((HttpServletRequest)request);
        ServletExternalContextUtilTest.assertEquals((String)"Windows-31J", (String)encoding);
    }

    public void testIsPost_GET() throws Exception {
        MockHttpServletRequest request = this.getRequest();
        request.setMethod("GET");
        ServletExternalContextUtilTest.assertEquals((boolean)false, (boolean)ServletExternalContextUtil.isPost((ExternalContext)this.getFacesContext().getExternalContext()));
    }

    public void testIsPost_POST() throws Exception {
        MockHttpServletRequest request = this.getRequest();
        request.setMethod("POST");
        ServletExternalContextUtilTest.assertEquals((boolean)true, (boolean)ServletExternalContextUtil.isPost((ExternalContext)this.getFacesContext().getExternalContext()));
    }

    private static class EmptyServletResponse
    implements ServletResponse {
        private EmptyServletResponse() {
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public void setCharacterEncoding(String arg0) {
        }

        public void setContentLength(int arg0) {
        }

        public void setContentType(String arg0) {
        }

        public void setBufferSize(int arg0) {
        }

        public int getBufferSize() {
            return 0;
        }

        public void flushBuffer() throws IOException {
        }

        public void resetBuffer() {
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void setLocale(Locale arg0) {
        }

        public Locale getLocale() {
            return null;
        }
    }

    private static class EmptyHttpServletResponse
    implements HttpServletResponse {
        private EmptyHttpServletResponse() {
        }

        public void addCookie(Cookie arg0) {
        }

        public boolean containsHeader(String arg0) {
            return false;
        }

        public String encodeURL(String arg0) {
            return null;
        }

        public String encodeRedirectURL(String arg0) {
            return null;
        }

        public String encodeUrl(String arg0) {
            return null;
        }

        public String encodeRedirectUrl(String arg0) {
            return null;
        }

        public void sendError(int arg0, String arg1) throws IOException {
        }

        public void sendError(int arg0) throws IOException {
        }

        public void sendRedirect(String arg0) throws IOException {
        }

        public void setDateHeader(String arg0, long arg1) {
        }

        public void addDateHeader(String arg0, long arg1) {
        }

        public void setHeader(String arg0, String arg1) {
        }

        public void addHeader(String arg0, String arg1) {
        }

        public void setIntHeader(String arg0, int arg1) {
        }

        public void addIntHeader(String arg0, int arg1) {
        }

        public void setStatus(int arg0) {
        }

        public void setStatus(int arg0, String arg1) {
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public void setCharacterEncoding(String arg0) {
        }

        public void setContentLength(int arg0) {
        }

        public void setContentType(String arg0) {
        }

        public void setBufferSize(int arg0) {
        }

        public int getBufferSize() {
            return 0;
        }

        public void flushBuffer() throws IOException {
        }

        public void resetBuffer() {
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void setLocale(Locale arg0) {
        }

        public Locale getLocale() {
            return null;
        }
    }

    private static class EmptyServletRequest
    implements ServletRequest {
        private EmptyServletRequest() {
        }

        public Object getAttribute(String arg0) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String getParameter(String arg0) {
            return null;
        }

        public Enumeration getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String arg0) {
            return null;
        }

        public Map getParameterMap() {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public void setAttribute(String arg0, Object arg1) {
        }

        public void removeAttribute(String arg0) {
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public boolean isSecure() {
            return false;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return null;
        }

        public String getRealPath(String arg0) {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public String getLocalName() {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }
    }

    private static class EmptyHttpServletRequest
    implements HttpServletRequest {
        private EmptyHttpServletRequest() {
        }

        public String getAuthType() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String arg0) {
            return 0L;
        }

        public String getHeader(String arg0) {
            return null;
        }

        public Enumeration getHeaders(String arg0) {
            return null;
        }

        public Enumeration getHeaderNames() {
            return null;
        }

        public int getIntHeader(String arg0) {
            return 0;
        }

        public String getMethod() {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public boolean isUserInRole(String arg0) {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getRequestURI() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getServletPath() {
            return null;
        }

        public HttpSession getSession(boolean arg0) {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public Object getAttribute(String arg0) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String getParameter(String arg0) {
            return null;
        }

        public Enumeration getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String arg0) {
            return null;
        }

        public Map getParameterMap() {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public void setAttribute(String arg0, Object arg1) {
        }

        public void removeAttribute(String arg0) {
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public boolean isSecure() {
            return false;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return null;
        }

        public String getRealPath(String arg0) {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public String getLocalName() {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }
    }
}

