/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.event.PhaseListener;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.FactoryFinderUtil;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.seasar.teeda.core.mock.MockLifecycleImpl;
import org.seasar.teeda.core.mock.MockPhaseListener;
import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.LifecycleUtil;

public class LifecycleUtilTest
extends TeedaTestCase {
    public void testGetLifecycle() {
        Lifecycle lifecycle = LifecycleUtil.getLifecycle();
        LifecycleUtilTest.assertNotNull((Object)lifecycle);
        LifecycleUtilTest.assertTrue((boolean)(lifecycle instanceof MockLifecycleImpl));
        LifecycleFactory factory = FactoryFinderUtil.getLifecycleFactory();
        MockLifecycleImpl mock = new MockLifecycleImpl();
        MockPhaseListener listener = new MockPhaseListener("mock");
        mock.addPhaseListener((PhaseListener)listener);
        factory.addLifecycle("hoge", (Lifecycle)mock);
        FacesConfigOptions.setLifecycleId((String)"hoge");
        lifecycle = LifecycleUtil.getLifecycle();
        LifecycleUtilTest.assertNotNull((Object)lifecycle);
        LifecycleUtilTest.assertTrue((boolean)(lifecycle instanceof MockLifecycleImpl));
        LifecycleUtilTest.assertEquals((String)"mock", (String)lifecycle.getPhaseListeners()[0].toString());
    }

    public void testGetLifecycleId() {
        LifecycleUtilTest.assertEquals((String)"DEFAULT", (String)LifecycleUtil.getLifecycleId());
        FacesConfigOptions.setLifecycleId((String)"hoge");
        LifecycleUtilTest.assertEquals((String)"hoge", (String)LifecycleUtil.getLifecycleId());
    }
}

