/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.mock.MockUIInput;
import org.seasar.teeda.core.render.html.HtmlOutputLabelRenderer;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class HtmlOutputLabelRendererTest
extends RendererTest {
    private HtmlOutputLabelRenderer renderer;
    private MockHtmlOutputLabel htmlOutputLabel;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlOutputLabelRenderer();
        this.htmlOutputLabel = new MockHtmlOutputLabel();
        this.htmlOutputLabel.setRenderer((Renderer)this.renderer);
    }

    public void testEncodeBegin() throws Exception {
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputLabel);
        HtmlOutputLabelRendererTest.assertEquals((String)"<label>", (String)this.getResponseText());
    }

    public void testEncode_NoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLabel);
        HtmlOutputLabelRendererTest.assertEquals((String)"<label></label>", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlOutputLabel.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLabel);
        HtmlOutputLabelRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncodeBegin_WithValue() throws Exception {
        this.htmlOutputLabel.setValue("aaa");
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputLabel);
        HtmlOutputLabelRendererTest.assertEquals((String)"<label>aaa", (String)this.getResponseText());
    }

    public void testEncodeBegin_WithId() throws Exception {
        this.htmlOutputLabel.setId("someId");
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputLabel);
        HtmlOutputLabelRendererTest.assertEquals((String)"<label id=\"someId\">", (String)this.getResponseText());
    }

    public void testEncodeBegin_WithUnknownAttribute1() throws Exception {
        this.htmlOutputLabel.getAttributes().put("aaa", "bbb");
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputLabel);
        HtmlOutputLabelRendererTest.assertEquals((String)"<label aaa=\"bbb\">", (String)this.getResponseText());
    }

    public void testEncodeBegin_WithUnknownAttribute2() throws Exception {
        this.htmlOutputLabel.getAttributes().put("a.a", "bbb");
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputLabel);
        HtmlOutputLabelRendererTest.assertEquals((String)"<label>", (String)this.getResponseText());
    }

    public void testEncodeBegin_WithFor() throws Exception {
        this.htmlOutputLabel.setFor("bb");
        try {
            this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputLabel);
            HtmlOutputLabelRendererTest.fail();
        }
        catch (IllegalStateException ise) {
            ExceptionAssert.assertMessageExist(ise);
        }
    }

    public void testEncodeBegin_WithForComponent() throws Exception {
        this.htmlOutputLabel.setFor("forComponentId");
        MockUIInput forComponent = new MockUIInput();
        forComponent.setId("forComponentId");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setId("parentForm");
        parent.getChildren().add(this.htmlOutputLabel);
        parent.getChildren().add(forComponent);
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputLabel);
        HtmlOutputLabelRendererTest.assertEquals((String)"<label for=\"forComponentId\">", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlOutputLabel.setAccesskey("a");
        this.htmlOutputLabel.setDir("b");
        this.htmlOutputLabel.setFor("c");
        this.htmlOutputLabel.setLang("d");
        this.htmlOutputLabel.setOnblur("e");
        this.htmlOutputLabel.setOnclick("f");
        this.htmlOutputLabel.setOndblclick("g");
        this.htmlOutputLabel.setOnfocus("h");
        this.htmlOutputLabel.setOnkeydown("i");
        this.htmlOutputLabel.setOnkeypress("j");
        this.htmlOutputLabel.setOnkeyup("k");
        this.htmlOutputLabel.setOnmousedown("l");
        this.htmlOutputLabel.setOnmousemove("m");
        this.htmlOutputLabel.setOnmouseout("n");
        this.htmlOutputLabel.setOnmouseover("o");
        this.htmlOutputLabel.setOnmouseup("p");
        this.htmlOutputLabel.setStyle("q");
        this.htmlOutputLabel.setStyleClass("r");
        this.htmlOutputLabel.setTabindex("s");
        this.htmlOutputLabel.setTitle("t");
        this.htmlOutputLabel.setValue("u");
        this.htmlOutputLabel.setId("v");
        MockUIComponentBase child = new MockUIComponentBase();
        child.setId("c");
        this.htmlOutputLabel.getChildren().add(child);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlOutputLabel);
        Diff diff = new Diff("<label id=\"v\" accesskey=\"a\" dir=\"b\" for=\"c\" lang=\"d\" onblur=\"e\" onclick=\"f\" ondblclick=\"g\" onfocus=\"h\" onkeydown=\"i\" onkeypress=\"j\" onkeyup=\"k\" onmousedown=\"l\" onmousemove=\"m\" onmouseout=\"n\" onmouseover=\"o\" onmouseup=\"p\" style=\"q\" class=\"r\" tabindex=\"s\" title=\"t\">u</label>", this.getResponseText());
        HtmlOutputLabelRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testGetConvertedValue() throws Exception {
        MockConverter converter = new MockConverter(){

            public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
                return value + ".testGetConvertedValue";
            }
        };
        this.htmlOutputLabel.setConverter((Converter)converter);
        Object convertedValue = this.renderer.getConvertedValue((FacesContext)this.getFacesContext(), (UIComponent)this.htmlOutputLabel, (Object)"c");
        HtmlOutputLabelRendererTest.assertEquals((Object)"c.testGetConvertedValue", (Object)convertedValue);
    }

    public void testGetRendersChildren() throws Exception {
        HtmlOutputLabelRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlOutputLabelRenderer createHtmlOutputLabelRenderer() {
        return (HtmlOutputLabelRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlOutputLabelRenderer renderer = new HtmlOutputLabelRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    private static class MockHtmlOutputLabel
    extends HtmlOutputLabel {
        private Renderer renderer_ = null;

        private MockHtmlOutputLabel() {
        }

        public void setRenderer(Renderer renderer) {
            this.renderer_ = renderer;
        }

        protected Renderer getRenderer(FacesContext context) {
            if (this.renderer_ != null) {
                return this.renderer_;
            }
            return super.getRenderer(context);
        }
    }
}

