/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle.impl;

import java.util.Iterator;
import javax.faces.lifecycle.Lifecycle;
import org.seasar.teeda.core.exception.LifecycleIdAlreadyExistRuntimeException;
import org.seasar.teeda.core.exception.LifecycleIdNotFoundRuntimeException;
import org.seasar.teeda.core.lifecycle.LifecycleFactoryImpl;
import org.seasar.teeda.core.mock.MockLifecycleImpl;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class LifecycleFactoryImplTest
extends TeedaTestCase {
    public void testGetLifecycle_lifecycleNotFound() throws Exception {
        LifecycleFactoryImpl factory = new LifecycleFactoryImpl();
        try {
            factory.getLifecycle("DEFAULT");
            LifecycleFactoryImplTest.fail();
        }
        catch (LifecycleIdNotFoundRuntimeException expected) {
            LifecycleFactoryImplTest.success();
        }
    }

    public void testGetLifecycle() throws Exception {
        LifecycleFactoryImpl factory = new LifecycleFactoryImpl();
        MockLifecycleImplForLifecycleFactoryImplTest lifecycle = new MockLifecycleImplForLifecycleFactoryImplTest();
        factory.addLifecycle("aaa", (Lifecycle)lifecycle);
        Lifecycle l = factory.getLifecycle("aaa");
        LifecycleFactoryImplTest.assertNotNull((Object)l);
        LifecycleFactoryImplTest.assertTrue((boolean)(l instanceof MockLifecycleImplForLifecycleFactoryImplTest));
    }

    public void testAddLifecycle_alreadyRegistered() throws Exception {
        LifecycleFactoryImpl factory = new LifecycleFactoryImpl();
        MockLifecycleImplForLifecycleFactoryImplTest lifecycle = new MockLifecycleImplForLifecycleFactoryImplTest();
        factory.addLifecycle("aaa", (Lifecycle)lifecycle);
        try {
            factory.addLifecycle("aaa", (Lifecycle)lifecycle);
            LifecycleFactoryImplTest.fail();
        }
        catch (LifecycleIdAlreadyExistRuntimeException expected) {
            LifecycleFactoryImplTest.success();
        }
    }

    public void testGetLifecycleIds() throws Exception {
        LifecycleFactoryImpl factory = new LifecycleFactoryImpl();
        MockLifecycleImplForLifecycleFactoryImplTest lifecycle = new MockLifecycleImplForLifecycleFactoryImplTest();
        factory.addLifecycle("DEFAULT", (Lifecycle)lifecycle);
        Iterator itr = factory.getLifecycleIds();
        LifecycleFactoryImplTest.assertNotNull((Object)itr);
        LifecycleFactoryImplTest.assertEquals((String)"DEFAULT", (String)itr.next().toString());
    }

    private static class MockLifecycleImplForLifecycleFactoryImplTest
    extends MockLifecycleImpl {
        private MockLifecycleImplForLifecycleFactoryImplTest() {
        }
    }
}

