/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.seasar.framework.mock.portlet.MockPortletContextImpl;
import org.seasar.framework.mock.portlet.MockPortletRenderResponseImpl;
import org.seasar.framework.mock.portlet.MockPortletRequestImpl;
import org.seasar.teeda.core.application.NavigationHandlerImpl;
import org.seasar.teeda.core.application.navigation.NavigationCaseContext;
import org.seasar.teeda.core.application.navigation.NavigationContext;
import org.seasar.teeda.core.application.navigation.NavigationResource;
import org.seasar.teeda.core.context.portlet.PortletExternalContextImpl;
import org.seasar.teeda.core.context.portlet.PortletFacesContextImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class NavigationHandlerImplTest
extends TeedaTestCase {
    public void testHandleNavigation_exactMatch() throws Exception {
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setViewId("aaa");
        context.setViewRoot(root);
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("aaa", "from", "outcome", "bbb", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        handler.handleNavigation((FacesContext)context, "from", "outcome");
        NavigationHandlerImplTest.assertEquals((String)"bbb", (String)context.getViewRoot().getViewId());
    }

    public void testHandleNavigation_wildCardMatch() throws Exception {
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setViewId("aaabbb");
        context.setViewRoot(root);
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("aaa*", "from", "outcome", "bbb", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        handler.handleNavigation((FacesContext)context, "from", "outcome");
        NavigationHandlerImplTest.assertEquals((String)"bbb", (String)context.getViewRoot().getViewId());
    }

    public void testHandleNavigation_defaultMatch() throws Exception {
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setViewId("*");
        context.setViewRoot(root);
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("*", "from", "outcome", "bbb", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        handler.handleNavigation((FacesContext)context, "from", "outcome");
        NavigationHandlerImplTest.assertEquals((String)"bbb", (String)context.getViewRoot().getViewId());
    }

    public void testHandleNavigation_redirect() throws Exception {
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setViewId("id");
        context.setViewRoot(root);
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("id", "from", "outcome", "bbb", true);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        handler.handleNavigation((FacesContext)context, "from", "outcome");
        NavigationHandlerImplTest.assertEquals((String)"id", (String)context.getViewRoot().getViewId());
    }

    public void testHandleNavigation_redirectWithPortlet() throws Exception {
        MockPortletContextImpl portletContext = new MockPortletContextImpl("/hoge");
        PortletExternalContextImpl extContext = new PortletExternalContextImpl((PortletContext)portletContext, (PortletRequest)new MockPortletRequestImpl((PortletContext)portletContext), (PortletResponse)new MockPortletRenderResponseImpl());
        PortletFacesContextImpl context = new PortletFacesContextImpl((ExternalContext)extContext);
        UIViewRoot root = new UIViewRoot();
        root.setViewId("id");
        context.setViewRoot(root);
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("id", "from", "outcome", "bbb", true);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        handler.handleNavigation((FacesContext)context, "from", "outcome");
        NavigationHandlerImplTest.assertEquals((String)"bbb", (String)context.getViewRoot().getViewId());
    }

    public void testGetNavigationCaseContext_fromActionAndOutComeNotNull() throws Exception {
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("id", "action", "outcome", "to", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        NavigationCaseContext caseContext = handler.getNavigationCaseContext("action", "outcome", "id");
        NavigationHandlerImplTest.assertNotNull((Object)caseContext);
        NavigationHandlerImplTest.assertEquals((String)"action", (String)caseContext.getFromAction());
        NavigationHandlerImplTest.assertEquals((String)"outcome", (String)caseContext.getFromOutcome());
        NavigationHandlerImplTest.assertEquals((String)"to", (String)caseContext.getToViewId());
        NavigationHandlerImplTest.assertFalse((boolean)caseContext.isRedirect());
    }

    public void testGetNavigationCaseContext_outcomeIsNull() throws Exception {
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("id", "action", null, "to", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        NavigationCaseContext caseContext = handler.getNavigationCaseContext("action", "outcome", "id");
        NavigationHandlerImplTest.assertNotNull((Object)caseContext);
        NavigationHandlerImplTest.assertEquals((String)"action", (String)caseContext.getFromAction());
        NavigationHandlerImplTest.assertNull((Object)caseContext.getFromOutcome());
        NavigationHandlerImplTest.assertEquals((String)"to", (String)caseContext.getToViewId());
        NavigationHandlerImplTest.assertFalse((boolean)caseContext.isRedirect());
    }

    public void testNavigationCaseContext_fromActionIsNull() throws Exception {
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("id", null, "outcome", "to", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        NavigationCaseContext caseContext = handler.getNavigationCaseContext("action", "outcome", "id");
        NavigationHandlerImplTest.assertNotNull((Object)caseContext);
        NavigationHandlerImplTest.assertNull((Object)caseContext.getFromAction());
        NavigationHandlerImplTest.assertEquals((String)"outcome", (String)caseContext.getFromOutcome());
        NavigationHandlerImplTest.assertEquals((String)"to", (String)caseContext.getToViewId());
        NavigationHandlerImplTest.assertFalse((boolean)caseContext.isRedirect());
    }

    public void testNavigationCaseContext_fromActionAndOutComeNull() throws Exception {
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("id", null, null, "to", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        NavigationCaseContext caseContext = handler.getNavigationCaseContext("action", "outcome", "id");
        NavigationHandlerImplTest.assertNotNull((Object)caseContext);
        NavigationHandlerImplTest.assertNull((Object)caseContext.getFromAction());
        NavigationHandlerImplTest.assertNull((Object)caseContext.getFromOutcome());
        NavigationHandlerImplTest.assertEquals((String)"to", (String)caseContext.getToViewId());
        NavigationHandlerImplTest.assertFalse((boolean)caseContext.isRedirect());
    }

    public void testHandleNavigationMoreReallistic_likeNormalLogin() {
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setViewId("/index.jsp");
        context.setViewRoot(root);
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("/index.jsp", null, "login", "/welcome.jsp", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        handler.handleNavigation((FacesContext)context, "/index.jsp", "login");
        NavigationHandlerImplTest.assertEquals((String)"/welcome.jsp", (String)context.getViewRoot().getViewId());
    }

    public void testHandleNavigationMoreReallistic_likeNormalLogout() {
        MockFacesContext context = this.getFacesContext();
        UIViewRoot root = new UIViewRoot();
        root.setViewId("/index.jsp");
        context.setViewRoot(root);
        NavigationContext navContext = NavigationHandlerImplTest.createNavigationContext("*", null, "logout", "/logout.jsp", false);
        NavigationResource.addNavigationContext((NavigationContext)navContext);
        NavigationHandlerImpl handler = new NavigationHandlerImpl();
        handler.handleNavigation((FacesContext)context, "/index.jsp", "logout");
        NavigationHandlerImplTest.assertEquals((String)"/logout.jsp", (String)context.getViewRoot().getViewId());
    }

    public static NavigationContext createNavigationContext(String fromViewId, String fromAction, String outcome, String toViewId, boolean isRedirect) {
        NavigationContext navContext = new NavigationContext();
        navContext.setFromViewId(fromViewId);
        NavigationCaseContext caseContext = new NavigationCaseContext(fromAction, outcome, toViewId, isRedirect);
        navContext.addNavigationCaseContext(caseContext);
        return navContext;
    }
}

