/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.mock.NullUIComponent;

public class DateTimeConverterTest
extends AbstractConverterTestCase {
    private Locale defaultLocale;
    private TimeZone defaultTimeZone;

    protected void setUp() throws Exception {
        super.setUp();
        this.defaultLocale = Locale.getDefault();
        this.defaultTimeZone = TimeZone.getDefault();
    }

    protected void tearDown() throws Exception {
        Locale.setDefault(this.defaultLocale);
        TimeZone.setDefault(this.defaultTimeZone);
        super.tearDown();
    }

    public void testGetAsObject1() throws Exception {
        DateTimeConverter converter = (DateTimeConverter)this.createConverter();
        MockFacesContext context = this.getFacesContext();
        converter.setLocale(this.defaultLocale);
        converter.setTimeZone(this.defaultTimeZone);
        String pattern = "yyyy/MM/dd";
        converter.setPattern("yyyy/MM/dd");
        String dateValue = "2005/08/01";
        Date date = (Date)converter.getAsObject((FacesContext)context, (UIComponent)new NullUIComponent(), dateValue);
        Date dateTarget = this.createDateTarget("yyyy/MM/dd", this.defaultLocale, dateValue);
        DateTimeConverterTest.assertEquals((Object)date, (Object)dateTarget);
    }

    public void testGetAsObject2() throws Exception {
        MockFacesContext context = this.getFacesContext();
        DateTimeConverter converter = (DateTimeConverter)this.createConverter();
        Locale locale = Locale.JAPANESE;
        converter.setLocale(locale);
        converter.setTimeZone(TimeZone.getTimeZone("JST"));
        String dateValue = "2005/08/01";
        Date date = (Date)converter.getAsObject((FacesContext)context, (UIComponent)new NullUIComponent(), "2005/08/01");
        Date dateTarget = this.createDateTarget("yyyy/MM/dd", locale, "2005/08/01");
        DateTimeConverterTest.assertEquals((Object)date, (Object)dateTarget);
    }

    public void testGetAsObject3() throws Exception {
        MockFacesContext context = this.getFacesContext();
        DateTimeConverter converter = new DateTimeConverter();
        UIViewRoot viewRoot = new UIViewRoot();
        Locale locale = Locale.US;
        viewRoot.setLocale(locale);
        context.setViewRoot(viewRoot);
        TimeZone.setDefault(converter.getTimeZone());
        String pattern = "M/d/yy";
        converter.setPattern(pattern);
        String dateValue = "8/3/05";
        Date date = (Date)converter.getAsObject((FacesContext)context, (UIComponent)new NullUIComponent(), dateValue);
        Date dateTarget = this.createDateTarget(pattern, locale, dateValue);
        DateTimeConverterTest.assertEquals((Object)date, (Object)dateTarget);
    }

    public void testGetAsObject4() throws Exception {
        MockFacesContext context = this.getFacesContext();
        DateTimeConverter converter = new DateTimeConverter();
        converter.setTimeZone(TimeZone.getDefault());
        UIViewRoot viewRoot = new UIViewRoot();
        Locale locale = Locale.GERMAN;
        viewRoot.setLocale(locale);
        context.setViewRoot(viewRoot);
        String style = "medium";
        converter.setDateStyle(style);
        String type = "date";
        converter.setType(type);
        String dateValue = "04.08.2005";
        Object o3 = converter.getAsObject((FacesContext)context, (UIComponent)new NullUIComponent(), dateValue);
        SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateInstance(2, locale);
        Date dateTarget = format.parse(dateValue);
        DateTimeConverterTest.assertEquals((Object)o3, (Object)dateTarget);
    }

    public void testGetAsObject5() throws Exception {
        MockFacesContext context = this.getFacesContext();
        DateTimeConverter converter = new DateTimeConverter();
        converter.setTimeZone(TimeZone.getDefault());
        converter.setPattern("yyyy/MM/dd");
        converter.setLocale(this.defaultLocale);
        try {
            converter.getAsObject((FacesContext)context, (UIComponent)new MockUIComponent(), "200508/04");
            DateTimeConverterTest.fail();
        }
        catch (ConverterException e) {
            DateTimeConverterTest.assertTrue((boolean)true);
        }
    }

    public void testGetAsObject6() throws Exception {
        DateTimeConverter converter = (DateTimeConverter)this.createConverter();
        MockFacesContext context = this.getFacesContext();
        converter.setLocale(this.defaultLocale);
        converter.setTimeZone(this.defaultTimeZone);
        String pattern = "yy/MM/dd";
        converter.setPattern("yy/MM/dd");
        String dateValue = "26/08/01";
        Date date = (Date)converter.getAsObject((FacesContext)context, (UIComponent)new NullUIComponent(), dateValue);
        Date dateTarget = this.createDateTarget("yy/MM/dd", this.defaultLocale, dateValue);
        DateTimeConverterTest.assertEquals((Object)date, (Object)dateTarget);
    }

    public void testGetAsString() {
        Converter converter = this.createConverter();
        MockFacesContext context = this.getFacesContext();
        MockUIComponent component = new MockUIComponent();
        String value = converter.getAsString((FacesContext)context, (UIComponent)component, null);
        DateTimeConverterTest.assertEquals((String)value, (String)"");
        DateTimeConverter converter2 = new DateTimeConverter();
        String value2 = converter2.getAsString((FacesContext)context, (UIComponent)component, (Object)"a");
        DateTimeConverterTest.assertEquals((String)value2, (String)"a");
        DateTimeConverter converter3 = new DateTimeConverter();
        Locale defaultLocale = Locale.getDefault();
        converter3.setLocale(defaultLocale);
        String pattern3 = "yy/MM/dd";
        converter3.setPattern(pattern3);
        converter3.setTimeZone(TimeZone.getDefault());
        Date date3 = new Date();
        String value3 = converter3.getAsString((FacesContext)context, (UIComponent)component, (Object)date3);
        String val = DateTimeConverterTest.createDateFormat(pattern3, defaultLocale, date3);
        DateTimeConverterTest.assertEquals((String)value3, (String)val);
        DateTimeConverter converter4 = new DateTimeConverter();
        Locale usLocale = Locale.US;
        converter4.setLocale(usLocale);
        converter4.setTimeZone(TimeZone.getDefault());
        Date date4 = new Date();
        String value4 = converter4.getAsString((FacesContext)context, (UIComponent)component, (Object)date4);
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateInstance(3, usLocale);
        String val4 = formatter.format(date4);
        DateTimeConverterTest.assertNotSame((Object)value4, (Object)val4);
        System.out.println(value4);
        System.out.println(val4);
    }

    public void testIsTransient() {
        DateTimeConverter converter = new DateTimeConverter();
        converter.setTransient(true);
        DateTimeConverterTest.assertTrue((boolean)converter.isTransient());
    }

    public void testSetTransient() {
        DateTimeConverter converter = new DateTimeConverter();
        converter.setTransient(true);
        DateTimeConverterTest.assertTrue((boolean)converter.isTransient());
    }

    public void testSaveState() {
        DateTimeConverter converter = new DateTimeConverter();
        MockFacesContext context = this.getFacesContext();
        String dateStyle = "full";
        Locale locale = Locale.getDefault();
        String pattern = "yy.MM/dd";
        String timeStyle = "medium";
        TimeZone timeZone = TimeZone.getDefault();
        String type = "date";
        converter.setDateStyle(dateStyle);
        converter.setLocale(locale);
        converter.setPattern(pattern);
        converter.setTimeStyle(timeStyle);
        converter.setTimeZone(timeZone);
        converter.setType(type);
        Object o = converter.saveState((FacesContext)context);
        DateTimeConverterTest.assertTrue((boolean)(o instanceof Object[]));
        Object[] values = (Object[])o;
        DateTimeConverterTest.assertEquals((Object)values[0], (Object)dateStyle);
    }

    public void testRestoreState() {
        DateTimeConverter converter = new DateTimeConverter();
        MockFacesContext context = this.getFacesContext();
        String dateStyle = "full";
        Locale locale = Locale.getDefault();
        String pattern = "yy.MM/dd";
        String timeStyle = "medium";
        TimeZone timeZone = TimeZone.getDefault();
        String type = "date";
        Object[] values = new Object[]{dateStyle, locale, pattern, timeStyle, timeZone, type};
        converter.restoreState((FacesContext)context, (Object)values);
        DateTimeConverterTest.assertEquals((Object)converter.getLocale(), (Object)locale);
    }

    public void testGetDateStyle() {
        DateTimeConverter converter = new DateTimeConverter();
        DateTimeConverterTest.assertEquals((String)"default", (String)converter.getDateStyle());
        converter.setDateStyle("full");
        DateTimeConverterTest.assertEquals((String)"full", (String)converter.getDateStyle());
    }

    public void testSetDateStyle() {
        DateTimeConverter converter = new DateTimeConverter();
        converter.setDateStyle("long");
        DateTimeConverterTest.assertEquals((String)"long", (String)converter.getDateStyle());
    }

    public void testGetLocale() {
        DateTimeConverter converter = new DateTimeConverter();
        Locale locale = Locale.getDefault();
        converter.setLocale(locale);
        DateTimeConverterTest.assertEquals((Object)locale, (Object)converter.getLocale());
    }

    public void testSetLocaleAsString() {
        DateTimeConverter converter = new DateTimeConverter();
        Locale locale = new Locale("en", "US");
        converter.setLocaleAsString("en_US");
        DateTimeConverterTest.assertEquals((Object)locale, (Object)converter.getLocale());
    }

    private Date createDateTarget(String pattern, Locale locale, String date) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        return formatter.parse(date);
    }

    private static String createDateFormat(String pattern, Locale locale, Object date) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, locale);
        try {
            return formatter.format(date);
        }
        catch (Exception e) {
            DateTimeConverterTest.fail();
            return null;
        }
    }

    public void testConstants() throws Exception {
        DateTimeConverterTest.assertEquals((String)"javax.faces.DateTime", (String)"javax.faces.DateTime");
    }

    protected Converter createConverter() {
        return this.createDateTimeConverter();
    }

    private DateTimeConverter createDateTimeConverter() {
        return new DateTimeConverter();
    }
}

