/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.AbstractConverterTestCase;
import javax.faces.convert.BooleanConverter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.seasar.teeda.core.mock.MockUIComponent;

public class BooleanConverterTest
extends AbstractConverterTestCase {
    public void testGetAsObject_success() throws Exception {
        Converter converter = this.createConverter();
        String value = "true";
        Object o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        BooleanConverterTest.assertTrue((boolean)(o instanceof Boolean));
        Boolean result = (Boolean)o;
        BooleanConverterTest.assertEquals((String)value, (String)result.toString());
        BooleanConverterTest.assertEquals((boolean)true, (boolean)result);
        value = "false";
        o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        result = (Boolean)o;
        BooleanConverterTest.assertEquals((String)value, (String)result.toString());
        BooleanConverterTest.assertEquals((boolean)false, (boolean)result);
        value = "other";
        o = converter.getAsObject((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), value);
        result = (Boolean)o;
        BooleanConverterTest.assertNotSame((Object)value, (Object)result.toString());
        BooleanConverterTest.assertEquals((boolean)false, (boolean)result);
    }

    public void testGetAsString_convertSuccess() throws Exception {
        Converter converter = this.createConverter();
        Boolean b = new Boolean(true);
        String str = converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)b);
        BooleanConverterTest.assertEquals((String)b.toString(), (String)str);
    }

    public void testGetAsString_convertFail() throws Exception {
        Converter converter = this.createConverter();
        Integer i = new Integer(1);
        try {
            converter.getAsString((FacesContext)this.getFacesContext(), (UIComponent)new MockUIComponent(), (Object)i);
            BooleanConverterTest.fail();
        }
        catch (ConverterException e) {
            BooleanConverterTest.assertTrue((boolean)true);
        }
    }

    public void testConstants() throws Exception {
        BooleanConverterTest.assertEquals((String)"javax.faces.Boolean", (String)"javax.faces.Boolean");
    }

    protected Converter createConverter() {
        return this.createBooleanConverter();
    }

    protected BooleanConverter createBooleanConverter() {
        return new BooleanConverter();
    }
}

