/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.faces.component.ComponentUtil_;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseId;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.MockViewHandler;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ComponentUtils_Test
extends TeedaTestCase {
    private static final String DECODE = "decode";
    private static final String UPDATE = "update";
    private static final String VALIDATE = "validate";

    public void testProcessAppropriatePhaseAction_callSuccess() throws Exception {
        LinkedList notify = new LinkedList();
        MockNotifyUIComponent component = new MockNotifyUIComponent(notify);
        ComponentUtil_.processAppropriatePhaseAction((FacesContext)this.getFacesContext(), (UIComponent)component, (PhaseId)PhaseId.APPLY_REQUEST_VALUES);
        ComponentUtil_.processAppropriatePhaseAction((FacesContext)this.getFacesContext(), (UIComponent)component, (PhaseId)PhaseId.UPDATE_MODEL_VALUES);
        ComponentUtil_.processAppropriatePhaseAction((FacesContext)this.getFacesContext(), (UIComponent)component, (PhaseId)PhaseId.PROCESS_VALIDATIONS);
        ComponentUtils_Test.assertEquals((Object)DECODE, notify.get(0));
        ComponentUtils_Test.assertEquals((Object)UPDATE, notify.get(1));
        ComponentUtils_Test.assertEquals((Object)VALIDATE, notify.get(2));
    }

    public void testProcessAppropriatePhaseAction_illegalAragument() throws Exception {
        LinkedList notify = new LinkedList();
        MockNotifyUIComponent component = new MockNotifyUIComponent(notify);
        try {
            ComponentUtil_.processAppropriatePhaseAction((FacesContext)this.getFacesContext(), (UIComponent)component, (PhaseId)PhaseId.INVOKE_APPLICATION);
            ComponentUtils_Test.fail();
        }
        catch (IllegalArgumentException expected) {
            ComponentUtils_Test.success();
        }
    }

    public void testGetValueBindingValue_getValue() throws Exception {
        MockUIComponent component = new MockUIComponent();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"HOGE");
        component.setValueBinding("hoge", (ValueBinding)vb);
        Object o = ComponentUtil_.getValueBindingValue((UIComponent)component, (String)"hoge");
        ComponentUtils_Test.assertEquals((Object)"HOGE", (Object)o);
    }

    public void testGetValueBindingValue_getNull() throws Exception {
        MockUIComponent component = new MockUIComponent();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"HOGE");
        component.setValueBinding("foo", (ValueBinding)vb);
        Object o = ComponentUtil_.getValueBindingValue((UIComponent)component, (String)"hoge");
        ComponentUtils_Test.assertNull((Object)o);
    }

    public void testGetValueBindingType_getType() throws Exception {
        MockUIComponent component = new MockUIComponent();
        MockValueBinding vb = new MockValueBinding();
        vb.setType(MockUIComponent.class);
        component.setValueBinding("foo", (ValueBinding)vb);
        Class type = ComponentUtil_.getValueBindingType((UIComponent)component, (String)"foo");
        ComponentUtils_Test.assertEquals((Object)MockUIComponent.class, (Object)type);
    }

    public void testGetValueBindingType_getNull() throws Exception {
        MockUIComponent component = new MockUIComponent();
        MockValueBinding vb = new MockValueBinding();
        vb.setType(MockUIComponent.class);
        component.setValueBinding("foo", (ValueBinding)vb);
        Class type = ComponentUtil_.getValueBindingType((UIComponent)component, (String)"bar");
        ComponentUtils_Test.assertNull((Object)type);
    }

    public void testConvertToBoolean() throws Exception {
        ComponentUtils_Test.assertEquals((Object)Boolean.TRUE, (Object)ComponentUtil_.convertToBoolean((boolean)true));
        ComponentUtils_Test.assertEquals((Object)Boolean.FALSE, (Object)ComponentUtil_.convertToBoolean((boolean)false));
    }

    public void testConvertToPrimitiveBoolean() throws Exception {
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.convertToPrimitiveBoolean((Object)Boolean.TRUE));
        ComponentUtils_Test.assertFalse((boolean)ComponentUtil_.convertToPrimitiveBoolean((Object)Boolean.FALSE));
        ComponentUtils_Test.assertFalse((boolean)ComponentUtil_.convertToPrimitiveBoolean(null));
        ComponentUtils_Test.assertFalse((boolean)ComponentUtil_.convertToPrimitiveBoolean((Object)"hoge"));
    }

    public void testCreateConverter() throws Exception {
        this.getApplication().addConverter(MockUIComponent.class, MockConverter.class.getName());
        Converter c = ComponentUtil_.createConverter((FacesContext)this.getFacesContext(), (Class)MockUIComponent.class);
        ComponentUtils_Test.assertNotNull((Object)c);
        ComponentUtils_Test.assertTrue((boolean)(c instanceof MockConverter));
    }

    public void testIsPerformNoConversion() throws Exception {
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.isPerformNoConversion(null));
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.isPerformNoConversion((Class)String.class));
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.isPerformNoConversion((Class)Object.class));
        ComponentUtils_Test.assertFalse((boolean)ComponentUtil_.isPerformNoConversion((Class)MockUIComponent.class));
    }

    public void testCalculateLocale() throws Exception {
        MockViewHandler handler = this.getViewHandler();
        Locale org = handler.calculateLocale((FacesContext)this.getFacesContext());
        handler.setLocale(Locale.JAPANESE);
        this.setViewHandler(handler);
        Locale l = ComponentUtil_.calculateLocale((FacesContext)this.getFacesContext());
        ComponentUtils_Test.assertEquals((Object)Locale.JAPANESE, (Object)l);
        this.getViewHandler().setLocale(org);
    }

    public void testGetLocale() throws Exception {
        this.getFacesContext().getViewRoot().setLocale(Locale.CANADA);
        ComponentUtils_Test.assertEquals((Object)Locale.CANADA, (Object)ComponentUtil_.getLocale((FacesContext)this.getFacesContext()));
    }

    public void testIsLocaleShort_null() throws Exception {
        try {
            ComponentUtil_.isLocaleShort(null);
            ComponentUtils_Test.fail();
        }
        catch (NullPointerException expected) {
            ComponentUtils_Test.success();
        }
    }

    public void testIsLocaleShort_short() throws Exception {
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.isLocaleShort((String)"en"));
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.isLocaleShort((String)"ja"));
    }

    public void testIsLocaleShort_longName() throws Exception {
        ComponentUtils_Test.assertFalse((boolean)ComponentUtil_.isLocaleShort((String)Locale.US.toString()));
        ComponentUtils_Test.assertFalse((boolean)ComponentUtil_.isLocaleShort((String)Locale.JAPAN.toString()));
    }

    public void testIsLocaleLong_null() throws Exception {
        try {
            ComponentUtil_.isLocaleLong(null);
            ComponentUtils_Test.fail();
        }
        catch (NullPointerException expected) {
            ComponentUtils_Test.success();
        }
    }

    public void testIsLocaleLong_long() throws Exception {
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.isLocaleLong((String)Locale.US.toString()));
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.isLocaleLong((String)Locale.JAPAN.toString()));
    }

    public void testValueMatches_allValuesAreNull() throws Exception {
        SelectItem item = new SelectItem();
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        list.add(item);
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.valueMatches(null, list.iterator()));
    }

    public void testValueMatches_allValuesAreNotNull() throws Exception {
        SelectItem item = new SelectItem();
        item.setValue((Object)"hoge");
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        list.add(item);
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.valueMatches((Object)"hoge", list.iterator()));
    }

    public void testValueMatches_hasSelectItemGroup() throws Exception {
        SelectItemGroup group = new SelectItemGroup();
        SelectItem item = new SelectItem();
        item.setValue((Object)"aaa");
        group.setSelectItems(new SelectItem[]{item});
        ArrayList<SelectItemGroup> list = new ArrayList<SelectItemGroup>();
        list.add(group);
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.valueMatches((Object)"aaa", list.iterator()));
    }

    public void testIsObjectArray() throws Exception {
        ComponentUtils_Test.assertTrue((boolean)ComponentUtil_.isObjectArray((Object)new Object[0]));
        ComponentUtils_Test.assertFalse((boolean)ComponentUtil_.isObjectArray((Object)"hoge"));
    }

    private static class MockNotifyUIComponent
    extends MockUIComponent {
        private List notify_;

        public MockNotifyUIComponent(List notify) {
            this.notify_ = notify;
        }

        public void processDecodes(FacesContext context) {
            this.notify_.add(ComponentUtils_Test.DECODE);
        }

        public void processUpdates(FacesContext context) {
            this.notify_.add(ComponentUtils_Test.UPDATE);
        }

        public void processValidators(FacesContext context) {
            this.notify_.add(ComponentUtils_Test.VALIDATE);
        }
    }
}

