/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.HashMap;
import java.util.Map;
import javax.faces.convert.Converter;
import javax.faces.internal.ConverterBuilder;
import org.seasar.framework.util.ArrayUtil;

public class ConverterResource {
    private static Map converterPairs = new HashMap();
    private static ConverterBuilder builder;

    protected ConverterResource() {
    }

    public static synchronized Converter getConverter(String expression) {
        if (builder == null) {
            return null;
        }
        ConverterPair[] pairs = (ConverterPair[])converterPairs.get(expression);
        return builder.build(expression, pairs);
    }

    public static synchronized void addConverter(String expression, String converterName) {
        ConverterResource.addConverter(expression, converterName, new HashMap());
    }

    public static synchronized void addConverter(String expression, String converterName, Map properties) {
        ConverterPair pair = new ConverterPair(converterName, properties);
        Object[] pairs = (ConverterPair[])converterPairs.get(expression);
        if (pairs == null) {
            pairs = new ConverterPair[]{};
        }
        converterPairs.put(expression, ArrayUtil.add((Object[])pairs, (Object)pair));
    }

    public static synchronized void removeConverter(String expression) {
        converterPairs.remove(expression);
        if (builder != null) {
            builder.clearConverter(expression);
        }
    }

    public static void removeAll() {
        converterPairs.clear();
        if (builder != null) {
            builder.clearAll();
        }
    }

    public static void setConverterBuilder(ConverterBuilder cb) {
        builder = cb;
    }

    public static class ConverterPair {
        public String converterName;
        public Map properties;

        public ConverterPair(String converterName, Map properties) {
            this.converterName = converterName;
            this.properties = properties;
        }
    }
}

