/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory.property;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.container.AccessTypeDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.Expression;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AccessTypeDefFactory;
import org.seasar.framework.container.assembler.BindingTypeDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AnnotationHandlerFactory;
import org.seasar.framework.container.factory.PropertyDefBuilder;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.ognl.OgnlExpression;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyDefBuilder<T extends Annotation>
implements PropertyDefBuilder {
    protected AnnotationHandler handler = AnnotationHandlerFactory.getAnnotationHandler();

    @Override
    public PropertyDef createPropertyDef(AnnotationHandler annotationHandler, BeanDesc beanDesc, PropertyDesc propertyDesc) {
        if (!propertyDesc.hasWriteMethod()) {
            return null;
        }
        Method method = propertyDesc.getWriteMethod();
        T annotation = method.getAnnotation(this.getAnnotationType());
        if (annotation == null) {
            return null;
        }
        return this.createPropertyDef(propertyDesc.getPropertyName(), AccessTypeDefFactory.PROPERTY, annotation);
    }

    @Override
    public PropertyDef createPropertyDef(AnnotationHandler annotationHandler, BeanDesc beanDesc, Field field) {
        T annotation = field.getAnnotation(this.getAnnotationType());
        if (annotation == null) {
            return null;
        }
        return this.createPropertyDef(field.getName(), AccessTypeDefFactory.FIELD, annotation);
    }

    protected abstract Class<T> getAnnotationType();

    protected abstract PropertyDef createPropertyDef(String var1, AccessTypeDef var2, T var3);

    protected ComponentDef createComponentDef(Class<?> componentClass) {
        return this.createComponentDef(componentClass, InstanceDefFactory.SINGLETON);
    }

    protected ComponentDef createComponentDef(Class<?> componentClass, InstanceDef instanceDef) {
        ComponentDef componentDef = this.handler.createComponentDef(componentClass, instanceDef);
        this.handler.appendDI(componentDef);
        this.handler.appendAspect(componentDef);
        this.handler.appendInterType(componentDef);
        this.handler.appendInitMethod(componentDef);
        this.handler.appendDestroyMethod(componentDef);
        return componentDef;
    }

    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef) {
        return this.createPropertyDef(propertyName, accessTypeDef, "");
    }

    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef, String expression) {
        return this.createPropertyDef(propertyName, accessTypeDef, expression, null);
    }

    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef, ComponentDef child) {
        return this.createPropertyDef(propertyName, accessTypeDef, "", child);
    }

    protected PropertyDef createPropertyDef(String propertyName, AccessTypeDef accessTypeDef, String expression, ComponentDef child) {
        PropertyDefImpl propertyDef = new PropertyDefImpl(propertyName);
        propertyDef.setAccessTypeDef(accessTypeDef);
        propertyDef.setBindingTypeDef(BindingTypeDefFactory.MUST);
        if (!StringUtil.isEmpty((String)expression)) {
            propertyDef.setExpression((Expression)new OgnlExpression(expression));
        }
        if (child != null) {
            propertyDef.setChildComponentDef(child);
        }
        return propertyDef;
    }
}

