/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.message;

import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.message.MessageResourceBundle;
import org.seasar.framework.message.MessageResourceBundleFacade;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.ResourceUtil;

public class MessageResourceBundleFactory {
    private static final String PROPERTIES_EXT = ".properties";
    private static final Object NOT_FOUND = new Object();
    private static Map cache = new HashMap();
    private static boolean initialized = false;

    public static MessageResourceBundle getBundle(String baseName) {
        return MessageResourceBundleFactory.getBundle(baseName, Locale.getDefault());
    }

    public static MessageResourceBundle getBundle(String baseName, Locale locale) throws ResourceNotFoundRuntimeException {
        MessageResourceBundle bundle = MessageResourceBundleFactory.getNullableBundle(baseName, locale);
        if (bundle != null) {
            return bundle;
        }
        throw new ResourceNotFoundRuntimeException(baseName);
    }

    public static MessageResourceBundle getNullableBundle(String baseName) {
        return MessageResourceBundleFactory.getNullableBundle(baseName, Locale.getDefault());
    }

    public static MessageResourceBundle getNullableBundle(String baseName, Locale locale) {
        AssertionUtil.assertNotNull("baseName", baseName);
        AssertionUtil.assertNotNull("locale", locale);
        String base = baseName.replace('.', '/');
        String[] bundleNames = MessageResourceBundleFactory.calcurateBundleNames(base, locale);
        MessageResourceBundleFacade parentFacade = null;
        MessageResourceBundleFacade facade = null;
        int length = bundleNames.length;
        for (int i = 0; i < length; ++i) {
            facade = MessageResourceBundleFactory.loadFacade(bundleNames[i] + PROPERTIES_EXT);
            if (parentFacade == null) {
                parentFacade = facade;
                continue;
            }
            if (facade == null) continue;
            facade.setParent(parentFacade);
            parentFacade = facade;
        }
        if (parentFacade != null) {
            return parentFacade.getBundle();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MessageResourceBundleFacade loadFacade(String path) {
        Map map = cache;
        synchronized (map) {
            Object cachedFacade;
            if (!initialized) {
                DisposableUtil.add(new Disposable(){

                    public void dispose() {
                        MessageResourceBundleFactory.clear();
                        initialized = false;
                    }
                });
                initialized = true;
            }
            if ((cachedFacade = cache.get(path)) == NOT_FOUND) {
                return null;
            }
            if (cachedFacade != null) {
                return (MessageResourceBundleFacade)cachedFacade;
            }
            URL url = ResourceUtil.getResourceNoException(path);
            if (url != null) {
                MessageResourceBundleFacade facade = new MessageResourceBundleFacade(url);
                cache.put(path, facade);
                return facade;
            }
            cache.put(path, NOT_FOUND);
        }
        return null;
    }

    protected static String[] calcurateBundleNames(String baseName, Locale locale) {
        boolean v;
        boolean c;
        boolean l;
        int length = 1;
        boolean bl = l = locale.getLanguage().length() > 0;
        if (l) {
            ++length;
        }
        boolean bl2 = c = locale.getCountry().length() > 0;
        if (c) {
            ++length;
        }
        boolean bl3 = v = locale.getVariant().length() > 0;
        if (v) {
            ++length;
        }
        String[] result = new String[length];
        int index = 0;
        result[index++] = baseName;
        if (!(l || c || v)) {
            return result;
        }
        StringBuffer buffer = new StringBuffer(baseName);
        buffer.append('_');
        buffer.append(locale.getLanguage());
        if (l) {
            result[index++] = new String(buffer);
        }
        if (!c && !v) {
            return result;
        }
        buffer.append('_');
        buffer.append(locale.getCountry());
        if (c) {
            result[index++] = new String(buffer);
        }
        if (!v) {
            return result;
        }
        buffer.append('_');
        buffer.append(locale.getVariant());
        result[index++] = new String(buffer);
        return result;
    }

    public static void clear() {
        cache.clear();
    }
}

