/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.RenderPreparable;
import javax.faces.internal.UIComponentUtil;
import javax.faces.render.Renderer;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.render.RenderPreparableRenderer;

public abstract class RenderPreparableUtil {
    protected RenderPreparableUtil() {
    }

    public static void encodeBeforeForRenderer(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        Renderer renderer = UIComponentUtil.getRenderer(context, component);
        if (renderer != null && renderer instanceof RenderPreparableRenderer) {
            ((RenderPreparableRenderer)((Object)renderer)).encodeBefore(context, component);
        }
    }

    public static void encodeBeforeForComponent(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        String componentName = component.getClass().getName();
        if (!componentName.endsWith("TCondition") && !component.isRendered()) {
            return;
        }
        if (component instanceof RenderPreparable) {
            ((RenderPreparable)((Object)component)).preEncodeBegin(context);
        }
        if (component.getChildCount() > 0) {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                RenderPreparableUtil.encodeBeforeForComponent(context, child);
            }
        }
    }

    public static void encodeAfterForComponent(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (component.getChildCount() > 0) {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                RenderPreparableUtil.encodeAfterForComponent(context, child);
            }
        }
        if (component instanceof RenderPreparable) {
            ((RenderPreparable)((Object)component)).postEncodeEnd(context);
        }
    }
}

