/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.util.Map;
import java.util.Set;
import org.seasar.extension.jdbc.SqlFileSelect;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.parameter.LobParameter;
import org.seasar.extension.jdbc.parameter.Parameter;
import org.seasar.extension.jdbc.parameter.TemporalParameter;
import org.seasar.extension.jdbc.query.AbstractSqlSelect;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.sql.Node;
import org.seasar.extension.sql.SqlContext;
import org.seasar.extension.sql.cache.NodeCache;
import org.seasar.extension.sql.context.SqlContextImpl;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;
import org.seasar.framework.util.IntegerConversionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFileSelectImpl<T>
extends AbstractSqlSelect<T, SqlFileSelect<T>>
implements SqlFileSelect<T> {
    protected String path;
    protected Object parameter;
    protected Node node;
    protected SqlContext sqlContext;

    public SqlFileSelectImpl(JdbcManagerImplementor jdbcManager, Class<T> baseClass, String path) {
        this(jdbcManager, baseClass, path, null);
    }

    public SqlFileSelectImpl(JdbcManagerImplementor jdbcManager, Class<T> baseClass, String path, Object parameter) {
        super(jdbcManager, baseClass);
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.parameter = parameter;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareNode();
        this.prepareParameter();
        this.prepareSql();
    }

    protected void prepareNode() throws ResourceNotFoundRuntimeException {
        this.node = NodeCache.getNode(this.path, this.jdbcManager.getDialect().getName());
        if (this.node == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new ResourceNotFoundRuntimeException(this.path);
        }
    }

    protected void prepareParameter() {
        this.sqlContext = new SqlContextImpl();
        if (this.parameter != null) {
            Class<?> clazz = this.parameter.getClass();
            if (ValueTypes.isSimpleType(clazz) || TemporalParameter.class == clazz || LobParameter.class == clazz) {
                this.sqlContext.addArg("$1", this.parameter, clazz);
            } else if (this.parameter instanceof Map) {
                Map paramMap = (Map)this.parameter;
                Set entrySet = paramMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    Object value = entry.getValue();
                    Object key = entry.getKey();
                    if (key == null || !(key instanceof CharSequence)) continue;
                    String name = ((Object)((CharSequence)key)).toString();
                    if (name.equals("limit")) {
                        this.limit = IntegerConversionUtil.toPrimitiveInt(value);
                        continue;
                    }
                    if (name.equals("offset")) {
                        this.offset = IntegerConversionUtil.toPrimitiveInt(value);
                        continue;
                    }
                    this.sqlContext.addArg(name, value, value == null ? String.class : value.getClass());
                }
            } else {
                BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
                for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
                    PropertyDesc pd = beanDesc.getPropertyDesc(i);
                    if (!pd.isReadable()) continue;
                    Object value = pd.getValue(this.parameter);
                    if (pd.getPropertyName().equals("limit")) {
                        this.limit = IntegerConversionUtil.toPrimitiveInt((Object)value);
                        continue;
                    }
                    if (pd.getPropertyName().equals("offset")) {
                        this.offset = IntegerConversionUtil.toPrimitiveInt((Object)value);
                        continue;
                    }
                    value = Parameter.wrapIfNecessary(pd, value);
                    this.sqlContext.addArg(pd.getPropertyName(), value, pd.getPropertyType());
                }
            }
        }
        this.node.accept(this.sqlContext);
        Object[] vars = this.sqlContext.getBindVariables();
        Class[] types = this.sqlContext.getBindVariableTypes();
        int size = vars.length;
        for (int i = 0; i < size; ++i) {
            this.addParam(vars[i], types[i]);
        }
    }

    protected void prepareSql() {
        String sql = this.sqlContext.getSql();
        this.executedSql = this.count ? this.convertGetCountSql(sql) : this.convertLimitSql(sql);
    }
}

