/*
 * Copyright 2004-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.teeda.extension.exception;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 */
public class IllegalLayoutPathRuntimeException extends SRuntimeException {

    private static final long serialVersionUID = 1L;

    private String path;

    private String viewRootPath;

    public IllegalLayoutPathRuntimeException(String path, String viewRootPath) {
        super("ETDA0108", new Object[] { path, viewRootPath });
        this.path = path;
        this.viewRootPath = viewRootPath;
    }

    /**
     * @return Returns the path.
     */
    public String getPath() {
        return path;
    }

    /**
     * @return Returns the viewRootPath.
     */
    public String getViewRootPath() {
        return viewRootPath;
    }

}
