/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.teeda.core.util.HTMLEncodeUtil;
import org.seasar.teeda.core.util.ServletContextUtil;
import org.seasar.teeda.extension.exception.HtmlNotFoundRuntimeExcpetion;
import org.seasar.teeda.extension.html.HtmlDesc;
import org.seasar.teeda.extension.html.HtmlDescCache;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.HtmlParser;
import org.seasar.teeda.extension.html.impl.HtmlDescImpl;

public class HtmlDescCacheImpl
implements HtmlDescCache {
    private Map htmlDescs = new HashMap();
    private ServletContext servletContext;
    private HtmlParser htmlParser;
    private S2Container container;

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public synchronized HtmlDesc getHtmlDesc(String viewId) {
        return (HtmlDesc)this.htmlDescs.get(viewId);
    }

    public synchronized HtmlDesc createHtmlDesc(String viewId) {
        File file;
        HtmlDesc htmlDesc = null;
        String realPath = this.servletContext.getRealPath(viewId);
        if (realPath != null && (file = new File(realPath)).exists()) {
            htmlDesc = this.createHtmlDescFromRealPath(file, viewId);
        }
        if (htmlDesc == null) {
            htmlDesc = this.createHtmlDescFromResource(viewId);
        }
        this.htmlDescs.put(viewId, htmlDesc);
        return htmlDesc;
    }

    protected HtmlDesc createHtmlDescFromRealPath(File file, String viewId) {
        BufferedInputStream is = new BufferedInputStream(FileInputStreamUtil.create((File)file));
        return this.createHtmlDesc(is, file, viewId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HtmlDesc createHtmlDescFromResource(String viewId) {
        InputStream is = ServletContextUtil.getResourceAsStream((ServletContext)this.servletContext, (String)viewId);
        if (is == null) {
            throw new HtmlNotFoundRuntimeExcpetion(HTMLEncodeUtil.encode((String)viewId, (boolean)true, (boolean)true));
        }
        HtmlDesc htmlDesc = null;
        try {
            htmlDesc = this.createHtmlDesc(is, null, viewId);
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
        return htmlDesc;
    }

    private HtmlDesc createHtmlDesc(InputStream is, File file, String viewId) {
        String encoding;
        ExternalContext externalContext;
        FacesContext context;
        HtmlNode htmlNode = null;
        HttpServletRequest request = (HttpServletRequest)this.container.getRoot().getExternalContext().getRequest();
        if (request == null && (context = FacesContext.getCurrentInstance()) != null && (externalContext = context.getExternalContext()) != null) {
            request = (HttpServletRequest)externalContext.getRequest();
        }
        String string = encoding = request != null ? request.getCharacterEncoding() : "UTF-8";
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.htmlParser.setEncoding(encoding);
        htmlNode = this.htmlParser.parse(is, viewId);
        return new HtmlDescImpl(htmlNode, file);
    }

    public HtmlParser getHtmlParser() {
        return this.htmlParser;
    }

    public void setHtmlParser(HtmlParser htmlParser) {
        this.htmlParser = htmlParser;
    }
}

