/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class SelectManyListboxFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "selectManyListbox";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"select".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        if (pageDesc == null) {
            return false;
        }
        String id = elementNode.getId();
        if (id.lastIndexOf("Items") < 0) {
            id = id + "Items";
        }
        if (pageDesc.hasItemsProperty(id) || pageDesc.hasMapItemsProperty(id)) {
            return elementNode.getProperty("multiple") != null;
        }
        return false;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String pageName = pageDesc.getPageName();
        String id = elementNode.getId();
        String items = null;
        items = id.lastIndexOf("Items") >= 0 ? id : id + "Items";
        String target = items.substring(0, items.length() - "Items".length());
        properties.put("value", this.getBindingExpression(pageName, target));
        properties.put("items", this.getBindingExpression(pageName, items));
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    public boolean isLeaf() {
        return true;
    }
}

