/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.config.taglib.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.extension.config.taglib.impl.AbstractTaglibManager;
import org.seasar.teeda.extension.util.FileSystemTraversal;

public class FileSystemTaglibManagerImpl
extends AbstractTaglibManager {
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void init() {
        this.init("/WEB-INF/");
    }

    public void init(String path) {
        try {
            URL rootPath = this.servletContext.getResource(path);
            File root = ResourceUtil.getFile((URL)rootPath);
            this.init0(root);
        }
        catch (MalformedURLException e) {
            throw new IORuntimeException((IOException)e);
        }
    }

    private void init0(File root) {
        FileSystemTraversal.Handler handler = new FileSystemTraversal.Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void acceptFile(File file) {
                String fileName = file.getName();
                if (fileName.endsWith(".tld")) {
                    FileInputStream is = null;
                    try {
                        is = FileInputStreamUtil.create((File)file);
                        FileSystemTaglibManagerImpl.this.scanTld(is, fileName);
                    }
                    finally {
                        if (is != null) {
                            InputStreamUtil.close((InputStream)is);
                        }
                    }
                }
            }

            public void acceptDirectory(File file) {
            }
        };
        FileSystemTraversal.traverse(root, handler);
    }
}

