/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ActionDescCache;
import org.seasar.teeda.extension.html.HtmlSuffix;
import org.seasar.teeda.extension.html.impl.ActionDescImpl;

public class ActionDescCacheImpl
implements ActionDescCache {
    private Map actionDescs = new HashMap();
    public static final String namingConvention_BINDING = "bindingType=must";
    private NamingConvention namingConvention;
    private S2Container container;
    private HtmlSuffix htmlSuffix;

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setHtmlSuffix(HtmlSuffix htmlSuffix) {
        this.htmlSuffix = htmlSuffix;
    }

    public synchronized ActionDesc getActionDesc(String viewId) {
        viewId = this.htmlSuffix.normalizePath(viewId);
        return (ActionDesc)this.actionDescs.get(viewId);
    }

    public synchronized ActionDesc createActionDesc(String viewId) {
        viewId = this.htmlSuffix.normalizePath(viewId);
        String actionName = this.namingConvention.fromPathToActionName(viewId);
        if (!this.container.getRoot().hasComponentDef((Object)actionName)) {
            return null;
        }
        ComponentDef cd = this.container.getRoot().getComponentDef((Object)actionName);
        File file = null;
        if (HotdeployUtil.isHotdeploy()) {
            file = ResourceUtil.getResourceAsFileNoException((Class)cd.getComponentClass());
        }
        ActionDescImpl actionDesc = new ActionDescImpl(cd.getConcreteClass(), actionName, file);
        this.actionDescs.put(viewId, actionDesc);
        return actionDesc;
    }
}

