/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.util.Iterator;
import java.util.LinkedList;
import javax.faces.context.FacesContext;
import org.seasar.framework.util.StringUtil;

public abstract class PathUtil {
    public static String toAbsolutePath(FacesContext context, String path, String basePath) {
        if (path.charAt(0) == '/' || path.indexOf(58) != -1) {
            return path;
        }
        if (StringUtil.isEmpty((String)basePath)) {
            return path;
        }
        String contextRoot = context.getExternalContext().getRequestContextPath();
        String absolutePath = contextRoot + basePath + "/../" + path;
        return PathUtil.normalizePath(absolutePath);
    }

    protected static String normalizePath(String absolutePath) {
        LinkedList<String> list = new LinkedList<String>();
        String[] parts = absolutePath.substring(1).split("/");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if ("..".equals(part)) {
                list.removeLast();
                continue;
            }
            if (".".equals(part)) continue;
            list.addLast(part);
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return "/" + list.getFirst();
        }
        StringBuffer buf = new StringBuffer(absolutePath.length());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            buf.append('/').append(it.next());
        }
        return new String(buf);
    }
}

