/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.exception.TagNotFoundRuntimeException;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.extension.component.UIBody;
import org.seasar.teeda.extension.render.RendererListener;

public class TBodyRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.Body";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.Body";
    private static final String KEY_RENDERER_LISTENER = RendererListener.class.getName() + "_KEY_LISTENER_STACK";
    private static final IgnoreAttribute IGNORE_COMPONENT = TBodyRenderer.buildIgnoreComponent();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("body", component);
        this.renderRemainAttributes(component, writer, IGNORE_COMPONENT);
    }

    public static void addRendererListener(UIBody body, RendererListener listener) {
        AssertionUtil.assertNotNull((String)"listener", (Object)listener);
        Map attributes = body.getAttributes();
        ArrayList<RendererListener> listeners = (ArrayList<RendererListener>)attributes.get(KEY_RENDERER_LISTENER);
        if (listeners == null) {
            listeners = new ArrayList<RendererListener>();
        }
        listeners.add(listener);
        attributes.put(KEY_RENDERER_LISTENER, listeners);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        ResponseWriter writer = context.getResponseWriter();
        UIBody body = (UIBody)component;
        Map attributes = body.getAttributes();
        List listeners = (List)attributes.remove(KEY_RENDERER_LISTENER);
        if (listeners != null) {
            Iterator itr = listeners.iterator();
            while (itr.hasNext()) {
                RendererListener listener = (RendererListener)itr.next();
                listener.renderBeforeBodyEnd(context);
            }
        }
        writer.endElement("body");
    }

    protected static IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = new IgnoreAttribute();
        ignore.addAttributeName("javax.faces.webapp.COMPONENT_IDS");
        return ignore;
    }

    public static UIBody findParentBody(UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIBody); parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new TagNotFoundRuntimeException("body");
        }
        return (UIBody)parent;
    }
}

