/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class RadioItemFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "radioItem";

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (pageDesc == null) {
            return false;
        }
        if (!"input".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        if (!"radio".equals(elementNode.getProperty("type"))) {
            return false;
        }
        String name = elementNode.getProperty("name");
        if (name == null) {
            return false;
        }
        ElementNode inputRadioNode = this.findParentInputRadioNode(elementNode, pageDesc, name);
        return inputRadioNode != null;
    }

    private ElementNode findParentInputRadioNode(ElementNode elementNode, PageDesc pageDesc, String name) {
        for (ElementNode parentNode = elementNode.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
            String id;
            String tagName = parentNode.getTagName();
            if (!"span".equalsIgnoreCase(tagName) && !"div".equalsIgnoreCase(tagName) || (id = parentNode.getId()) == null || !pageDesc.hasProperty(id) || !name.equals(id)) continue;
            return parentNode;
        }
        return null;
    }

    public boolean isLeaf() {
        return true;
    }
}

