/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.portlet;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.portlet.MultipartFormDataActionRequestWrapper;

public class MultipartFormDataFilter
implements PortletFilter {
    public static final String DOFILTER_CALLED = "org.seasar.teeda.extension.portlet.MultipartFormDataFilter.doFilterCalled";
    public static final int DEFAULT_MAX_SIZE = 0x6400000;
    public static final int DEFAULT_MAX_FILE_SIZE = 0x6400000;
    public static final int DEFAULT_THREASHOLD_SIZE = 102400;
    protected int maxSize;
    protected int maxFileSize;
    protected int thresholdSize;
    protected String repositoryPath = null;
    protected String encoding = null;
    protected PortletConfig portletConfig;

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        this.maxSize = this.getSizeParameter(filterConfig, "uploadMaxSize", 0x6400000);
        this.maxFileSize = this.getSizeParameter(filterConfig, "uploadMaxFileSize", 0x6400000);
        this.thresholdSize = this.getSizeParameter(filterConfig, "uploadThresholdSize", 102400);
        this.repositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
        this.encoding = filterConfig.getInitParameter("encoding");
        this.portletConfig = filterConfig.getPortletConfig();
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (request.getAttribute(DOFILTER_CALLED) != null) {
            chain.processActionFilter(request, response);
            return;
        }
        request.setAttribute(DOFILTER_CALLED, (Object)Boolean.TRUE);
        if (!PortletFileUpload.isMultipartContent((ActionRequest)request)) {
            chain.processActionFilter(request, response);
            return;
        }
        MultipartFormDataActionRequestWrapper multipartRequest = new MultipartFormDataActionRequestWrapper(request, this.maxSize, this.maxFileSize, this.thresholdSize, this.repositoryPath, this.encoding);
        chain.processActionFilter((ActionRequest)multipartRequest, response);
    }

    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws PortletException, IOException {
        chain.renderFilter(request, response);
    }

    public void destroy() {
    }

    protected int getSizeParameter(PortletFilterConfig filterConfig, String parameterName, int defaultValue) {
        String param = filterConfig.getInitParameter(parameterName);
        if (StringUtil.isEmpty((String)param)) {
            return defaultValue;
        }
        param = param.toLowerCase();
        int factor = 1;
        String number = param;
        if (param.endsWith("g")) {
            factor = 0x40000000;
            number = param.substring(0, param.length() - 1);
        } else if (param.endsWith("m")) {
            factor = 0x100000;
            number = param.substring(0, param.length() - 1);
        } else if (param.endsWith("k")) {
            factor = 1024;
            number = param.substring(0, param.length() - 1);
        }
        return Integer.parseInt(number) * factor;
    }
}

