/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.validator;

import java.math.BigDecimal;
import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.internal.UIInputUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.util.TargetCommandUtil;
import org.seasar.teeda.extension.validator.ValidationTargetSelectable;

public class TNumberLengthValidator
implements Validator,
StateHolder,
ValidationTargetSelectable {
    public static final String INTEGRAL_MESSAGE_ID = "org.seasar.teeda.extension.validator.TNumberLengthValidator.INTEGRAL";
    public static final String FRACTION_MESSAGE_ID = "org.seasar.teeda.extension.validator.TNumberLengthValidator.FRACTION";
    public static final String BOTH_MESSAGE_ID = "org.seasar.teeda.extension.validator.TNumberLengthValidator.BOTH";
    public static final String DOUBLE_NOT_ALLOWED = "org.seasar.teeda.extension.validator.TNumberLengthValidator.DOUBLE_NOT_ALLOWED";
    private static final BigDecimal ZERO = new BigDecimal("0");
    public static final int INTEGRAL_DEFAULT_MIN = 1;
    public static final int INTEGRAL_DEFAULT_MAX = Integer.MAX_VALUE;
    public static final int FRACTAL_DEFAULT_MIN = 0;
    public static final int FRACTAL_DEFAULT_MAX = Integer.MAX_VALUE;
    protected int integralMin = 1;
    protected int integralMax = Integer.MAX_VALUE;
    protected int fractionMin = 0;
    protected int fractionMax = Integer.MAX_VALUE;
    protected boolean transientValue = false;
    protected String target;
    protected String[] targets;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (UIInputUtil.isEmpty((Object)value)) {
            return;
        }
        if (!this.isTargetCommandValidation(context, this.targets)) {
            return;
        }
        Digits digits = this.getDigits(context, component, value);
        boolean integralSuccess = this.validateIntegral(digits);
        boolean fractionSuccess = this.validateFraction(digits);
        if (!integralSuccess && !fractionSuccess) {
            Object[] args = new Object[]{UIComponentUtil.getLabel((UIComponent)component), new Integer(this.integralMin), new Integer(this.integralMax), new Integer(this.fractionMin), new Integer(this.fractionMax)};
            FacesMessage message = FacesMessageUtil.getMessage((FacesContext)context, (String)BOTH_MESSAGE_ID, (Object[])args);
            throw new ValidatorException(message, BOTH_MESSAGE_ID, args);
        }
        if (!integralSuccess) {
            Object[] args = new Object[]{UIComponentUtil.getLabel((UIComponent)component), new Integer(this.integralMin), new Integer(this.integralMax)};
            FacesMessage message = FacesMessageUtil.getMessage((FacesContext)context, (String)INTEGRAL_MESSAGE_ID, (Object[])args);
            throw new ValidatorException(message, INTEGRAL_MESSAGE_ID, args);
        }
        if (!fractionSuccess) {
            Object[] args = new Object[]{UIComponentUtil.getLabel((UIComponent)component), new Integer(this.fractionMin), new Integer(this.fractionMax)};
            FacesMessage message = FacesMessageUtil.getMessage((FacesContext)context, (String)FRACTION_MESSAGE_ID, (Object[])args);
            throw new ValidatorException(message, FRACTION_MESSAGE_ID, args);
        }
    }

    private boolean validateFraction(Digits digits) {
        int fraction;
        return this.fractionMin > this.fractionMax || (fraction = digits.getFraction()) >= this.fractionMin && this.fractionMax >= fraction;
    }

    private boolean validateIntegral(Digits digits) {
        int integral;
        return this.integralMin > this.integralMax || (integral = digits.getIntegral()) >= this.integralMin && this.integralMax >= integral;
    }

    protected Digits getDigits(FacesContext context, UIComponent component, Object value) {
        Digits digits = new Digits();
        if (value instanceof Integer) {
            Integer num = (Integer)value;
            int abs = Math.abs(num);
            digits.setIntegral(String.valueOf(abs).length());
        } else if (value instanceof Long) {
            Long num = (Long)value;
            long abs = Math.abs(num);
            digits.setIntegral(String.valueOf(abs).length());
        } else if (value instanceof BigDecimal) {
            Locale locale;
            String decimalSeparator;
            String s;
            int pos;
            BigDecimal num = (BigDecimal)value;
            if (num.compareTo(ZERO) < 0) {
                num = num.negate();
            }
            if (-1 < (pos = (s = num.toString()).indexOf(decimalSeparator = NumberConversionUtil.findDecimalSeparator((Locale)(locale = context.getViewRoot().getLocale()))))) {
                digits.setIntegral(s.substring(0, pos).length());
                digits.setFraction(s.substring(pos + 1).length());
            } else {
                digits.setIntegral(s.length());
            }
        } else if (value instanceof Double) {
            Object[] args = new Object[]{UIComponentUtil.getLabel((UIComponent)component), value};
            FacesMessage message = FacesMessageUtil.getMessage((FacesContext)context, (String)DOUBLE_NOT_ALLOWED, (Object[])args);
            throw new ValidatorException(message, DOUBLE_NOT_ALLOWED, args);
        }
        return digits;
    }

    public int getFractionMax() {
        return this.fractionMax;
    }

    public void setFractionMax(int fractionMax) {
        this.fractionMax = fractionMax;
    }

    public int getFractionMin() {
        return this.fractionMin;
    }

    public void setFractionMin(int fractionMin) {
        this.fractionMin = fractionMin;
    }

    public int getIntegralMax() {
        return this.integralMax;
    }

    public void setIntegralMax(int integralMax) {
        this.integralMax = integralMax;
    }

    public int getIntegralMin() {
        return this.integralMin;
    }

    public void setIntegralMin(int integralMin) {
        this.integralMin = integralMin;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.integralMin = (Integer)values[0];
        this.integralMax = (Integer)values[1];
        this.fractionMin = (Integer)values[2];
        this.fractionMax = (Integer)values[3];
        this.target = (String)values[4];
        this.setTarget(this.target);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{new Integer(this.integralMin), new Integer(this.integralMax), new Integer(this.fractionMin), new Integer(this.fractionMax), this.target};
        return state;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public boolean isTargetCommandValidation(FacesContext context, String[] targets) {
        return TargetCommandUtil.isTargetCommand(context, targets);
    }

    public String[] getTargets() {
        return this.targets;
    }

    protected static class Digits {
        private int integral;
        private int fraction;

        protected Digits() {
        }

        public int getFraction() {
            return this.fraction;
        }

        public void setFraction(int fraction) {
            this.fraction = fraction;
        }

        public int getIntegral() {
            return this.integral;
        }

        public void setIntegral(int integral) {
            this.integral = integral;
        }
    }
}

