/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.Application;
import org.seasar.teeda.core.config.faces.assembler.ApplicationAssemblerHelper;
import org.seasar.teeda.core.config.faces.assembler.impl.ActionListenerAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.DefaultRenderKitIdAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.LocaleConfigAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.MessageBundleAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.NavigationHandlerAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.PropertyResolverAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.StateManagerAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.VariableResolverAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.ViewHandlerAssembler;
import org.seasar.teeda.core.config.faces.element.LocaleConfigElement;
import org.seasar.teeda.core.util.IteratorUtil;

public class ApplicationAssemblerHelperImpl
implements ApplicationAssemblerHelper {
    private Application application_;
    private List assemblers_ = Collections.EMPTY_LIST;

    public ApplicationAssemblerHelperImpl(Application application, List assemblers) {
        this.application_ = application;
        this.assemblers_ = assemblers;
    }

    public void setupActionListenerAssembler(List listenerNames) {
        Iterator itr = IteratorUtil.getIterator(listenerNames);
        while (itr.hasNext()) {
            String actionListenerName = (String)itr.next();
            this.assemblers_.add(new ActionListenerAssembler(actionListenerName, this.application_));
        }
    }

    public void setupLocaleConfigAssembler(List localeConfigs) {
        Iterator itr = IteratorUtil.getIterator(localeConfigs);
        while (itr.hasNext()) {
            LocaleConfigElement localeConfig = (LocaleConfigElement)itr.next();
            this.assemblers_.add(new LocaleConfigAssembler(localeConfig, this.application_));
        }
    }

    public void setupNavigationHandlerAssembler(List navigationHandlers) {
        Iterator itr = IteratorUtil.getIterator(navigationHandlers);
        while (itr.hasNext()) {
            String handlerName = (String)itr.next();
            this.assemblers_.add(new NavigationHandlerAssembler(handlerName, this.application_));
        }
    }

    public void setupPropertyResolverAssembler(List propertyResolvers) {
        Iterator itr = IteratorUtil.getIterator(propertyResolvers);
        while (itr.hasNext()) {
            String resolverName = (String)itr.next();
            this.assemblers_.add(new PropertyResolverAssembler(resolverName, this.application_));
        }
    }

    public void setupStateManagerAssembler(List stateManagers) {
        Iterator itr = IteratorUtil.getIterator(stateManagers);
        while (itr.hasNext()) {
            String stateManagerName = (String)itr.next();
            this.assemblers_.add(new StateManagerAssembler(stateManagerName, this.application_));
        }
    }

    public void setupVariableResolverAssembler(List variableResolvers) {
        Iterator itr = IteratorUtil.getIterator(variableResolvers);
        while (itr.hasNext()) {
            String resolverName = (String)itr.next();
            this.assemblers_.add(new VariableResolverAssembler(resolverName, this.application_));
        }
    }

    public void setupViewHandlerAssembler(List viewHandlers) {
        Iterator itr = IteratorUtil.getIterator(viewHandlers);
        while (itr.hasNext()) {
            String handlerName = (String)itr.next();
            this.assemblers_.add(new ViewHandlerAssembler(handlerName, this.application_));
        }
    }

    public void setupDefaultRenderKitIdAssembler(List defaultRenderKitIds) {
        Iterator itr = IteratorUtil.getIterator(defaultRenderKitIds);
        while (itr.hasNext()) {
            String defaultRenderKitId = (String)itr.next();
            this.assemblers_.add(new DefaultRenderKitIdAssembler(defaultRenderKitId, this.application_));
        }
    }

    public void setupMessageBundleAssembler(List messageBundles) {
        Iterator itr = IteratorUtil.getIterator(messageBundles);
        while (itr.hasNext()) {
            String messageBundle = (String)itr.next();
            this.assemblers_.add(new MessageBundleAssembler(messageBundle, this.application_));
        }
    }

    public List getCollectedAssemblers() {
        return this.assemblers_;
    }
}

