/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class TItemsSaveHiddenFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "inputHidden";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"input".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        if (!"hidden".equalsIgnoreCase(elementNode.getProperty("type"))) {
            return false;
        }
        if (pageDesc == null) {
            return false;
        }
        String id = elementNode.getId();
        if (!id.endsWith("Save")) {
            return false;
        }
        String targetId = id.substring(0, id.indexOf("Save"));
        return pageDesc.hasProperty(targetId);
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String id = elementNode.getId();
        String targetId = id.substring(0, id.indexOf("Save"));
        properties.put("value", this.getBindingExpression(pageDesc.getPageName(), targetId));
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }
}

