/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockMethodBinding;
import org.seasar.teeda.core.mock.MockPropertyResolver;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;

public class MockApplicationImpl
extends MockApplication {
    private String bundle_;
    private ActionListener actionListener_;
    private Locale defaultLocale_;
    private Collection locales_;
    private VariableResolver variableResolver_;
    private PropertyResolver propertyResolver_;
    private NavigationHandler navigationHandler_;
    private ViewHandler viewHandler_;
    private StateManager stateManager_;
    private String defaultRenderKitId_;
    private Map componentClassMap_ = new HashMap();
    private Map convertersById_ = new HashMap();
    private Map convertersByClass_ = new HashMap();
    private Map validators_ = new HashMap();
    private ValueBinding vb_;

    public ActionListener getActionListener() {
        return this.actionListener_;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener_ = actionListener;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale_;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale_ = locale;
    }

    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId_;
    }

    public void setDefaultRenderKitId(String renderKitId) {
        this.defaultRenderKitId_ = renderKitId;
    }

    public String getMessageBundle() {
        return this.bundle_;
    }

    public void setMessageBundle(String bundle) {
        this.bundle_ = bundle;
    }

    public Iterator getSupportedLocales() {
        return this.locales_ != null ? this.locales_.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public void setSupportedLocales(Collection locales) {
        this.locales_ = locales;
    }

    public NavigationHandler getNavigationHandler() {
        return this.navigationHandler_;
    }

    public void setNavigationHandler(NavigationHandler handler) {
        this.navigationHandler_ = handler;
    }

    public PropertyResolver getPropertyResolver() {
        if (this.propertyResolver_ == null) {
            this.propertyResolver_ = new MockPropertyResolver();
        }
        return this.propertyResolver_;
    }

    public void setPropertyResolver(PropertyResolver resolver) {
        this.propertyResolver_ = resolver;
    }

    public VariableResolver getVariableResolver() {
        if (this.variableResolver_ == null) {
            this.variableResolver_ = new MockVariableResolver();
        }
        return this.variableResolver_;
    }

    public void setVariableResolver(VariableResolver resolver) {
        this.variableResolver_ = resolver;
    }

    public ViewHandler getViewHandler() {
        if (this.viewHandler_ == null) {
            this.viewHandler_ = new MockViewHandlerImpl();
        }
        return this.viewHandler_;
    }

    public void setViewHandler(ViewHandler handler) {
        this.viewHandler_ = handler;
    }

    public StateManager getStateManager() {
        return this.stateManager_;
    }

    public void setStateManager(StateManager manager) {
        this.stateManager_ = manager;
    }

    public void addComponent(String componentType, String componentClassName) {
        Class clazz = ClassUtil.forName((String)componentClassName);
        this.componentClassMap_.put(componentType, clazz);
    }

    public UIComponent createComponent(String componentType) throws FacesException {
        Class componentClass = (Class)this.componentClassMap_.get(componentType);
        if (componentClass == null) {
            throw new FacesException();
        }
        return (UIComponent)ClassUtil.newInstance((Class)componentClass);
    }

    public UIComponent createComponent(ValueBinding vb, FacesContext context, String componentType) throws FacesException {
        Object obj = vb.getValue(context);
        if (obj instanceof UIComponent) {
            return (UIComponent)obj;
        }
        UIComponent component = this.createComponent(componentType);
        vb.setValue(context, component);
        return component;
    }

    public void addConverter(String converterId, String converterClass) {
        if (converterId == null || converterClass == null) {
            throw new IllegalArgumentException();
        }
        this.convertersById_.put(converterId, converterClass);
    }

    public void addConverter(Class targetClass, String converterClass) {
        if (targetClass == null || converterClass == null) {
            throw new IllegalArgumentException();
        }
        this.convertersByClass_.put(targetClass, converterClass);
    }

    public Converter createConverter(String converterId) {
        Converter converter = null;
        if (this.convertersById_.containsKey(converterId)) {
            String className = (String)this.convertersById_.get(converterId);
            converter = (Converter)ClassUtil.newInstance((String)className);
        }
        return converter;
    }

    public Converter createConverter(Class targetClass) {
        Converter converter = null;
        if (this.convertersByClass_.containsKey(targetClass)) {
            String className = (String)this.convertersByClass_.get(targetClass);
            converter = (Converter)ClassUtil.newInstance((String)className);
        }
        return converter;
    }

    public void addValidator(String validatorId, String validatorClass) {
        this.validators_.put(validatorId, validatorClass);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        String validatorClass = (String)this.validators_.get(validatorId);
        Validator v = null;
        if (validatorClass != null) {
            v = (Validator)ClassUtil.newInstance((String)validatorClass);
        }
        return v;
    }

    public Iterator getComponentTypes() {
        return null;
    }

    public Iterator getConverterIds() {
        return null;
    }

    public Iterator getConverterTypes() {
        return null;
    }

    public MethodBinding createMethodBinding(String ref, Class[] params) throws ReferenceSyntaxException {
        return new MockMethodBinding(ref);
    }

    public Iterator getValidatorIds() {
        return null;
    }

    public ValueBinding createValueBinding(String ref) throws ReferenceSyntaxException {
        if (this.vb_ != null) {
            return this.vb_;
        }
        return new MockValueBinding(ref);
    }

    public void addSupportedLocale(Locale locale) {
        if (this.locales_ != null) {
            this.locales_.add(locale);
        } else {
            this.locales_ = new ArrayList();
            this.locales_.add(locale);
        }
    }

    public void setValueBinding(ValueBinding vb) {
        this.vb_ = vb;
    }
}

