/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class MockSessionMap
implements Map {
    private HttpSession session_ = null;

    public MockSessionMap(HttpSession session) {
        this.session_ = session;
    }

    public void clear() {
        Iterator keys = this.keySet().iterator();
        while (keys.hasNext()) {
            this.session_.removeAttribute((String)keys.next());
        }
    }

    public boolean containsKey(Object key) {
        return this.session_.getAttribute(this.key(key)) != null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Enumeration keys = this.session_.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object next = this.session_.getAttribute((String)keys.nextElement());
            if (next != value) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        HashSet<Object> set = new HashSet<Object>();
        Enumeration keys = this.session_.getAttributeNames();
        while (keys.hasMoreElements()) {
            set.add(this.session_.getAttribute((String)keys.nextElement()));
        }
        return set;
    }

    public boolean equals(Object o) {
        return this.session_.equals(o);
    }

    public Object get(Object key) {
        return this.session_.getAttribute(this.key(key));
    }

    public int hashCode() {
        return this.session_.hashCode();
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public Set keySet() {
        HashSet set = new HashSet();
        Enumeration keys = this.session_.getAttributeNames();
        while (keys.hasMoreElements()) {
            set.add(keys.nextElement());
        }
        return set;
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        String skey = this.key(key);
        Object previous = this.session_.getAttribute(skey);
        this.session_.setAttribute(skey, value);
        return previous;
    }

    public void putAll(Map map) {
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.session_.setAttribute(key, value);
        }
    }

    public Object remove(Object key) {
        String skey = this.key(key);
        Object previous = this.session_.getAttribute(skey);
        this.session_.removeAttribute(skey);
        return previous;
    }

    public int size() {
        int n = 0;
        Enumeration keys = this.session_.getAttributeNames();
        while (keys.hasMoreElements()) {
            keys.nextElement();
            ++n;
        }
        return n;
    }

    public Collection values() {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration keys = this.session_.getAttributeNames();
        while (keys.hasMoreElements()) {
            list.add(this.session_.getAttribute((String)keys.nextElement()));
        }
        return list;
    }

    private String key(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (key instanceof String) {
            return (String)key;
        }
        return key.toString();
    }
}

