/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.ConvertUtil;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.AssertionUtil;

public class CharacterConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Character";
    public static final String CONVERSION_OBJECT_ID = CharacterConverter.class.getName() + ".CONVERSION";
    public static final String CONVERSION_STRING_ID = CharacterConverter.class.getName() + ".CONVERSION_STRING";

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            Object[] args = ConvertUtil.createExceptionMessageArgs(component, value);
            throw new ConverterException(FacesMessageUtil.getMessage(context, this.getObjectMessageId(), args));
        }
        try {
            return new Character(value.charAt(0));
        }
        catch (Exception e) {
            Object[] args = ConvertUtil.createExceptionMessageArgs(component, value);
            throw new ConverterException(FacesMessageUtil.getMessage(context, this.getObjectMessageId(), args), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return "";
        }
        try {
            return value instanceof String ? (String)value : ((Character)value).toString();
        }
        catch (Exception e) {
            Object[] args = ConvertUtil.createExceptionMessageArgs(component, value);
            throw new ConverterException(FacesMessageUtil.getMessage(context, this.getStringMessageId(), args), (Throwable)e);
        }
    }

    protected String getObjectMessageId() {
        return CONVERSION_OBJECT_ID;
    }

    protected String getStringMessageId() {
        return CONVERSION_STRING_ID;
    }
}

