/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;

public class GridFactoryUtil {
    static String getNaturalName(String id) {
        int pos = id.lastIndexOf("Grid");
        return id.substring(0, pos);
    }

    static boolean isMatchGrid(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (pageDesc == null) {
            return false;
        }
        if (!"table".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (!(GridFactoryUtil.isNoScroll(id) || GridFactoryUtil.isScrollHorizontal(id) || GridFactoryUtil.isScrollVertical(id))) {
            return false;
        }
        String itemsName = GridFactoryUtil.getItemsName(id);
        return pageDesc.hasItemsProperty(itemsName);
    }

    static boolean isNoScroll(String id) {
        return id.endsWith("Grid");
    }

    static boolean isScrollHorizontal(String id) {
        return id.endsWith("GridX") || id.endsWith("GridXY");
    }

    static boolean isScrollVertical(String id) {
        return id.endsWith("GridY") || id.endsWith("GridXY");
    }

    static String getItemsName(String id) {
        String naturalName = GridFactoryUtil.getNaturalName(id);
        String itemsName = naturalName + "Items";
        return itemsName;
    }

    static boolean isGridChild(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        ElementNode gridNode = GridFactoryUtil.findParentGridNode(elementNode, pageDesc, actionDesc);
        return gridNode != null;
    }

    static ElementNode findParentGridNode(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        for (ElementNode node = elementNode.getParent(); node != null; node = node.getParent()) {
            if (!GridFactoryUtil.isMatchGrid(node, pageDesc, actionDesc)) continue;
            return node;
        }
        return null;
    }
}

