/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.model.hdftypes;

import java.util.Hashtable;
import org.apache.poi.hdf.extractor.Utils;
import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.hdf.model.hdftypes.LFO;
import org.apache.poi.hdf.model.hdftypes.LFOLVL;
import org.apache.poi.hdf.model.hdftypes.LST;
import org.apache.poi.hdf.model.hdftypes.LVL;
import org.apache.poi.hdf.model.hdftypes.StyleSheet;

public class ListTables
implements HDFType {
    LFO[] _pllfo;
    Hashtable _lists = new Hashtable();

    public ListTables(byte[] plcflst, byte[] plflfo) {
        this.initLST(plcflst);
        this.initLFO(plflfo);
    }

    public LVL getLevel(int list, int level) {
        LFO override = this._pllfo[list - 1];
        for (int x = 0; x < override._clfolvl; ++x) {
            if (override._levels[x]._ilvl != level) continue;
            LFOLVL lfolvl = override._levels[x];
            if (lfolvl._fFormatting) {
                LST lst = (LST)this._lists.get(new Integer(override._lsid));
                LVL lvl = lfolvl._override;
                lvl._istd = Utils.convertBytesToShort(lst._rgistd, level * 2);
                return lvl;
            }
            if (!lfolvl._fStartAt) continue;
            LST lst = (LST)this._lists.get(new Integer(override._lsid));
            LVL lvl = lst._levels[level];
            LVL newLvl = (LVL)lvl.clone();
            newLvl._istd = Utils.convertBytesToShort(lst._rgistd, level * 2);
            newLvl._iStartAt = lfolvl._iStartAt;
            return newLvl;
        }
        LST lst = (LST)this._lists.get(new Integer(override._lsid));
        LVL lvl = lst._levels[level];
        lvl._istd = Utils.convertBytesToShort(lst._rgistd, level * 2);
        return lvl;
    }

    private void initLST(byte[] plcflst) {
        int length = Utils.convertBytesToShort(plcflst, 0);
        int nextLevelOffset = 0;
        for (int x = 0; x < length; ++x) {
            LST lst = new LST();
            lst._lsid = Utils.convertBytesToInt(plcflst, 2 + x * 28);
            lst._tplc = Utils.convertBytesToInt(plcflst, 6 + x * 28);
            System.arraycopy(plcflst, 10 + x * 28, lst._rgistd, 0, 18);
            byte code = plcflst[28 + x * 28];
            lst._fSimpleList = StyleSheet.getFlag(code & 1);
            this._lists.put(new Integer(lst._lsid), lst);
            lst._levels = lst._fSimpleList ? new LVL[1] : new LVL[9];
            for (int y = 0; y < lst._levels.length; ++y) {
                int offset = 2 + length * 28 + nextLevelOffset;
                lst._levels[y] = new LVL();
                nextLevelOffset += this.createLVL(plcflst, offset, lst._levels[y]);
            }
        }
    }

    private void initLFO(byte[] plflfo) {
        int lfoSize = Utils.convertBytesToInt(plflfo, 0);
        this._pllfo = new LFO[lfoSize];
        for (int x = 0; x < lfoSize; ++x) {
            LFO nextLFO = new LFO();
            nextLFO._lsid = Utils.convertBytesToInt(plflfo, 4 + x * 16);
            nextLFO._clfolvl = plflfo[16 + x * 16];
            nextLFO._levels = new LFOLVL[nextLFO._clfolvl];
            this._pllfo[x] = nextLFO;
        }
        int lfolvlOffset = lfoSize * 16 + 4;
        int lvlOffset = 0;
        int lfolvlNum = 0;
        for (int x = 0; x < lfoSize; ++x) {
            if (this._pllfo[x]._clfolvl == 0) {
                ++lfolvlNum;
                continue;
            }
            for (int y = 0; y < this._pllfo[x]._clfolvl; ++y) {
                int offset = lfolvlOffset + lfolvlNum * 8 + lvlOffset;
                LFOLVL lfolvl = new LFOLVL();
                lfolvl._iStartAt = Utils.convertBytesToInt(plflfo, offset);
                lfolvl._ilvl = Utils.convertBytesToInt(plflfo, offset + 4);
                lfolvl._fStartAt = StyleSheet.getFlag(lfolvl._ilvl & 0x10);
                lfolvl._fFormatting = StyleSheet.getFlag(lfolvl._ilvl & 0x20);
                lfolvl._ilvl &= 0xF;
                ++lfolvlNum;
                if (lfolvl._fFormatting) {
                    offset = lfolvlOffset + lfolvlNum * 8 + lvlOffset;
                    lfolvl._override = new LVL();
                    lvlOffset += this.createLVL(plflfo, offset, lfolvl._override);
                }
                this._pllfo[x]._levels[y] = lfolvl;
            }
        }
    }

    private int createLVL(byte[] data, int offset, LVL lvl) {
        int startingOffset = offset;
        lvl._iStartAt = Utils.convertBytesToInt(data, offset);
        offset += 4;
        lvl._nfc = data[offset++];
        byte code = data[offset++];
        lvl._jc = (byte)(code & 3);
        lvl._fLegal = StyleSheet.getFlag(code & 4);
        lvl._fNoRestart = StyleSheet.getFlag(code & 8);
        lvl._fPrev = StyleSheet.getFlag(code & 0x10);
        lvl._fPrevSpace = StyleSheet.getFlag(code & 0x20);
        lvl._fWord6 = StyleSheet.getFlag(code & 0x40);
        System.arraycopy(data, offset, lvl._rgbxchNums, 0, 9);
        offset += 9;
        lvl._ixchFollow = data[offset++];
        if (lvl._fWord6) {
            lvl._dxaSpace = Utils.convertBytesToInt(data, offset);
            lvl._dxaIndent = Utils.convertBytesToInt(data, offset + 4);
        }
        offset += 8;
        byte chpxSize = data[offset++];
        byte papxSize = data[offset++];
        lvl._chpx = new byte[chpxSize];
        lvl._papx = new byte[papxSize];
        System.arraycopy(data, offset, lvl._chpx, 0, chpxSize);
        System.arraycopy(data, offset + chpxSize, lvl._papx, 0, papxSize);
        int xstSize = Utils.convertBytesToShort(data, offset += papxSize + chpxSize + 2);
        offset += 2;
        lvl._xst = new char[xstSize];
        for (int x = 0; x < xstSize; ++x) {
            lvl._xst[x] = (char)Utils.convertBytesToShort(data, offset + x * 2);
        }
        return offset + xstSize * 2 - startingOffset;
    }
}

