/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;
import org.seasar.teeda.extension.html.factory.LabelFactoryUtil;
import org.seasar.teeda.extension.util.TeedaExtensionConfiguration;

public class OutputLabelFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "outputLabel";
    private NamingConvention namingConvention;

    public boolean isLeaf() {
        return true;
    }

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (TeedaExtensionConfiguration.getInstance().disableLabelFactory) {
            return false;
        }
        String tagName = elementNode.getTagName();
        if (!"label".equalsIgnoreCase(tagName)) {
            return false;
        }
        String id = elementNode.getId();
        return id != null;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        LabelFactoryUtil.storeTemplateValue(properties, elementNode);
        if (pageDesc == null) {
            return;
        }
        LabelFactoryUtil.storeLabelAttributesTo(properties, elementNode, pageDesc, this.namingConvention);
    }

    protected void customizeDynamicProperties(String base, Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (base == null) {
            return;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.customizeDynamicProperty(base, key, properties, elementNode, pageDesc, actionDesc);
        }
    }

    protected void customizeDynamicProperty(String base, String name, Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String propName;
        if (pageDesc == null) {
            return;
        }
        String pageName = pageDesc.getPageName();
        if (!StringUtil.isEmpty((String)base) && pageDesc.hasDynamicProperty(propName = base + "Value")) {
            properties.put("value", this.getBindingExpression(pageName, propName));
        }
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }
}

