/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import org.seasar.framework.util.StringUtil;

public class ContentTypeUtil {
    public static String getDefaultContentType() {
        return "text/html";
    }

    public static String getContentType(String contentTypeList) {
        int i;
        if (contentTypeList == null) {
            return ContentTypeUtil.getDefaultContentType();
        }
        String[] strs = StringUtil.split((String)contentTypeList, (String)",");
        String[] contentTypes = ContentTypeUtil.removeSemiColon(strs);
        for (i = 0; i < contentTypes.length; ++i) {
            if (!ContentTypeUtil.isHtmlContentType(contentTypes[i].trim())) continue;
            return "text/html";
        }
        for (i = 0; i < contentTypes.length; ++i) {
            if (!ContentTypeUtil.isXmlContentType(contentTypes[i].trim())) continue;
            return "application/xhtml+xml";
        }
        return ContentTypeUtil.getDefaultContentType();
    }

    public static String[] removeSemiColon(String[] contentTypes) {
        for (int i = 0; i < contentTypes.length; ++i) {
            String type = contentTypes[i];
            int index = type.indexOf(";");
            if (index == -1) continue;
            contentTypes[i] = type = type.substring(0, index);
        }
        return contentTypes;
    }

    public static boolean isHtmlContentType(String type) {
        return type.indexOf("text/html") != -1 || type.equals("*/*");
    }

    public static boolean isXmlContentType(String type) {
        return type.indexOf("application/xhtml+xml") != -1 || type.indexOf("application/xml") != -1 || type.indexOf("text/xml") != -1;
    }
}

