/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.DefaultDecoder;

public class AdjustableDecoder
extends DefaultDecoder {
    protected String getClientId(UIComponent component, FacesContext context) {
        String clientId = component.getClientId(context);
        return AdjustableDecoder.getAdjustedValue(clientId);
    }

    protected Map getRequestParameterMap(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        return this.adjustParamMap(paramMap);
    }

    protected Map getRequestParameterValuesMap(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterValuesMap();
        return this.adjustParamMap(paramMap);
    }

    protected Map adjustParamMap(Map paramMap) {
        HashMap map = new HashMap();
        Iterator itr = paramMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = (String)entry.getKey();
            key = AdjustableDecoder.getAdjustedValue(key);
            map.put(key, entry.getValue());
        }
        return map;
    }

    protected static String getAdjustedValue(String clientId) {
        AssertionUtil.assertNotNull((String)"clientId", (Object)clientId);
        if (clientId.indexOf("-") < 0) {
            return clientId;
        }
        String[] ids = StringUtil.split((String)clientId, (String)String.valueOf(':'));
        StringBuffer buf = new StringBuffer(128);
        for (int i = 0; i < ids.length; ++i) {
            String s = ids[i];
            int index = s.indexOf("-");
            if (index >= 0) {
                s = s.substring(0, index);
            }
            buf.append(s).append(':');
        }
        buf.setLength(buf.length() - 1);
        return buf.toString();
    }
}

