/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.exception.InvocationTargetRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.ErrorPageManager;
import org.seasar.teeda.core.util.ExternalContextUtil;
import org.seasar.teeda.core.util.MethodBindingUtil;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.core.util.NullErrorPageManagerImpl;
import org.seasar.teeda.extension.exception.IllegalPageTransitionException;
import org.seasar.teeda.extension.helper.PathHelper;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ActionDescCache;
import org.seasar.teeda.extension.html.HtmlComponentInvoker;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;
import org.seasar.teeda.extension.html.RedirectDesc;
import org.seasar.teeda.extension.html.impl.ScopeValueHelper;
import org.seasar.teeda.extension.util.RedirectUtil;

public class HtmlComponentInvokerImpl
implements HtmlComponentInvoker {
    private static Logger logger = Logger.getLogger((Class)HtmlComponentInvokerImpl.class);
    private NamingConvention namingConvention;
    private PathHelper pathHelper;
    public static final String errorManager_BINDING = "bindingType=may";
    private ErrorPageManager errorPageManager = new NullErrorPageManagerImpl();
    private PageDescCache pageDescCache;
    private ActionDescCache actionDescCache;

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public PathHelper getPathHelper() {
        return this.pathHelper;
    }

    public void setPathHelper(PathHelper pathHelper) {
        this.pathHelper = pathHelper;
    }

    public void setErrorPageManager(ErrorPageManager errorPageManager) {
        this.errorPageManager = errorPageManager;
    }

    public ActionDescCache getActionDescCache() {
        return this.actionDescCache;
    }

    public void setActionDescCache(ActionDescCache actionDescCache) {
        this.actionDescCache = actionDescCache;
    }

    public PageDescCache getPageDescCache() {
        return this.pageDescCache;
    }

    public void setPageDescCache(PageDescCache pageDescCache) {
        this.pageDescCache = pageDescCache;
    }

    public String invokeInitialize(FacesContext context, String componentName) {
        return this.invoke(context, componentName, "initialize");
    }

    public String invokePrerender(FacesContext context, String componentName) {
        return this.invoke(context, componentName, "prerender");
    }

    public String invoke(FacesContext context, String componentName, String methodName) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"methodName", (Object)methodName);
        if ("initialize".equals(methodName)) {
            this.setInitialized(context, componentName, true);
        }
        if (componentName == null) {
            return null;
        }
        String next = null;
        String fromAction = MethodBindingUtil.getFromAction((String)componentName, (String)methodName);
        String pageSuffix = this.namingConvention.getPageSuffix();
        if (!DIContainerUtil.hasComponent((Object)componentName)) {
            return null;
        }
        Object component = DIContainerUtil.getComponent((Object)componentName);
        Class<?> componentClass = component.getClass();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        Object ret = null;
        try {
            ret = beanDesc.invoke(component, methodName, null);
            ScopeValueHelper.removeIfDoFinish(methodName, context);
            if (ret instanceof Class) {
                Class retClass = (Class)ret;
                if (retClass != null && !retClass.getName().endsWith(pageSuffix)) {
                    throw new IllegalPageTransitionException(retClass);
                }
                next = this.getNextPageTransition(retClass);
            } else {
                next = (String)ret;
            }
            this.setRedirectDesc(context, methodName);
            NavigationHandlerUtil.handleNavigation((FacesContext)context, (String)fromAction, (String)next);
        }
        catch (Throwable e) {
            try {
                ExternalContext extContext;
                if (e instanceof InvocationTargetRuntimeException) {
                    e = e.getCause();
                }
                if (!this.errorPageManager.handleException(e, context, extContext = context.getExternalContext())) {
                    throw new EvaluationException(e);
                }
                context.responseComplete();
            }
            catch (IOException ioe) {
                logger.log((Throwable)ioe);
                throw new EvaluationException(e);
            }
        }
        return next;
    }

    protected void setRedirectDesc(FacesContext context, String methodName) {
        if (RedirectUtil.getRedirectDesc() != null) {
            return;
        }
        String viewId = ExternalContextUtil.getViewId((ExternalContext)context.getExternalContext());
        RedirectDesc redirectDesc = null;
        PageDesc pageDesc = this.pageDescCache.getPageDesc(viewId);
        ActionDesc actionDesc = this.actionDescCache.getActionDesc(viewId);
        if (actionDesc != null && actionDesc.hasRedirectDesc(methodName)) {
            redirectDesc = actionDesc.getRedirectDesc(methodName);
        }
        if (redirectDesc == null && pageDesc != null && pageDesc.hasRedirectDesc(methodName)) {
            redirectDesc = pageDesc.getRedirectDesc(methodName);
        }
        if (redirectDesc != null) {
            RedirectUtil.setRedirectDesc(redirectDesc);
        }
    }

    public boolean isInitialized(FacesContext context, String componentName) {
        String name;
        Map requestMap = context.getExternalContext().getRequestMap();
        Map map = (Map)requestMap.get(name = this.getClass().getName());
        if (map == null) {
            requestMap.put(name, new HashMap());
            return false;
        }
        if (map.containsKey(componentName)) {
            Boolean b = (Boolean)map.get(componentName);
            return b != null ? b : false;
        }
        return false;
    }

    protected void setInitialized(FacesContext context, String componentName, boolean initialized) {
        String name;
        Map requestMap = context.getExternalContext().getRequestMap();
        HashMap<String, Boolean> map = (HashMap<String, Boolean>)requestMap.get(name = this.getClass().getName());
        if (map == null) {
            map = new HashMap<String, Boolean>();
        }
        map.put(componentName, initialized);
        requestMap.put(name, map);
    }

    protected String getNextPageTransition(Class toPageClass) {
        String path = this.pathHelper.fromPageClassToViewRootRelativePath(toPageClass);
        path = path.substring(1);
        path = StringUtil.trimSuffix((String)path, (String)this.namingConvention.getViewExtension());
        return path.replaceAll("/", "_");
    }

    public String getComponentName(String path, String methodName) {
        ActionDesc actionDesc;
        String componentName = null;
        PageDesc pageDesc = this.pageDescCache.getPageDesc(path);
        if (pageDesc != null && pageDesc.hasMethod(methodName)) {
            componentName = pageDesc.getPageName();
        }
        if (componentName == null && (actionDesc = this.actionDescCache.getActionDesc(path)) != null && actionDesc.hasMethod(methodName)) {
            componentName = actionDesc.getActionName();
        }
        return componentName;
    }
}

