/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.util;

import java.util.List;
import java.util.Set;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.seasar.framework.jpa.PersistenceClassTransformer;
import org.seasar.framework.jpa.util.AbstractClassLoader;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformClassLoader
extends AbstractClassLoader {
    protected PersistenceClassTransformer persistenceClassTransformer;
    protected PersistenceUnitInfo persistenceUnitInfo;
    protected List<ClassTransformer> transformers = CollectionsUtil.newArrayList();

    public TransformClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public TransformClassLoader(ClassLoader parent) {
        super(parent);
    }

    public TransformClassLoader(ClassLoader parent, Set<String> includedNames) {
        super(parent, includedNames);
    }

    public void registerPersistenceClassTransformer(PersistenceClassTransformer persistenceClassTransformer) {
        this.persistenceClassTransformer = persistenceClassTransformer;
    }

    public void registerPersistenceUnitInfo(PersistenceUnitInfo persistenceUnitInfo) {
        this.persistenceUnitInfo = persistenceUnitInfo;
    }

    public void addTransformer(ClassTransformer transformer) {
        this.transformers.add(transformer);
    }

    @Override
    protected Class<?> doDefineClass(String className, byte[] bytes) {
        return this.persistenceClassTransformer.transform(this.persistenceUnitInfo, className, bytes);
    }
}

