/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.internal.RenderPreparable;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.extension.html.HtmlComponentInvoker;

public abstract class AbstractIncludeRenderer
extends AbstractRenderer
implements RenderPreparable {
    private HtmlComponentInvoker htmlComponentInvoker;

    public HtmlComponentInvoker getHtmlComponentInvoker() {
        return this.htmlComponentInvoker;
    }

    public void setHtmlComponentInvoker(HtmlComponentInvoker htmlComponentInvoker) {
        this.htmlComponentInvoker = htmlComponentInvoker;
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        Iterator i = component.getChildren().iterator();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            child.processDecodes(context);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
    }

    protected void invoke(FacesContext context, String includedViewId) {
        String componentName = this.htmlComponentInvoker.getComponentName(includedViewId, "initialize");
        if (componentName != null && !this.htmlComponentInvoker.isInitialized(context, componentName)) {
            this.htmlComponentInvoker.invokeInitialize(context, componentName);
        }
        if (context.getResponseComplete()) {
            return;
        }
        componentName = this.htmlComponentInvoker.getComponentName(includedViewId, "prerender");
        if (componentName != null) {
            this.htmlComponentInvoker.invokePrerender(context, componentName);
        }
        if (context.getResponseComplete()) {
            return;
        }
    }

    public void postEncodeEnd(FacesContext context) throws IOException {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null) {
            viewRoot.getChildren().clear();
        }
    }

    public void preEncodeBegin(FacesContext context) throws IOException {
    }
}

