/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.unit.RunNotifierCompatibility;
import org.seasar.framework.unit.S2TestIntrospector;
import org.seasar.framework.unit.S2TestMethodRunner;
import org.seasar.framework.unit.impl.ConventionTestIntrospector;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2TestClassMethodsRunner
extends Runner
implements Filterable,
Sortable {
    protected static Provider provider;
    protected final List<Method> testMethods;
    protected final Class<?> testClass;

    public S2TestClassMethodsRunner(Class<?> clazz) {
        this.testClass = clazz;
        this.testMethods = this.getTestMethods();
    }

    public static void dispose() {
        provider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        try {
            this.runBefores(notifier);
            this.runMethods(notifier);
        }
        catch (FailedBefore failedBefore) {
        }
        finally {
            this.runAfters(notifier);
        }
    }

    protected void runMethods(RunNotifier notifier) {
        if (this.testMethods.isEmpty()) {
            RunNotifierCompatibility.testAborted(notifier, this.getDescription(), new Exception("No runnable methods"));
        }
        for (Method method : this.testMethods) {
            this.invokeTestMethod(method, notifier);
        }
    }

    protected void runBefores(RunNotifier notifier) throws FailedBefore {
        try {
            List<Method> befores = this.getBeforeClassMethods();
            for (Method before : befores) {
                before.invoke(null, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            this.addFailure(e.getTargetException(), notifier);
            throw new FailedBefore();
        }
        catch (Throwable e) {
            this.addFailure(e, notifier);
            throw new FailedBefore();
        }
    }

    protected void runAfters(RunNotifier notifier) {
        List<Method> afters = this.getAfterClassMethods();
        for (Method after : afters) {
            try {
                after.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException e) {
                this.addFailure(e.getTargetException(), notifier);
            }
            catch (Throwable e) {
                this.addFailure(e, notifier);
            }
        }
    }

    protected void addFailure(Throwable targetException, RunNotifier notifier) {
        Failure failure = new Failure(this.getDescription(), targetException);
        notifier.fireTestFailure(failure);
    }

    protected List<Method> getTestMethods() {
        return S2TestClassMethodsRunner.getProvider().getTestMethods(this.testClass);
    }

    protected List<Method> getBeforeClassMethods() {
        return S2TestClassMethodsRunner.getProvider().getBeforeClassMethods(this.testClass);
    }

    protected List<Method> getAfterClassMethods() {
        return S2TestClassMethodsRunner.getProvider().getAfterClassMethods(this.testClass);
    }

    public Description getDescription() {
        Description spec = Description.createSuiteDescription((String)this.getName(), (Annotation[])new Annotation[0]);
        for (Method method : this.testMethods) {
            spec.addChild(this.methodDescription(method));
        }
        return spec;
    }

    protected String getName() {
        return this.getTestClass().getName();
    }

    protected Object createTest() throws Exception {
        return this.getTestClass().getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void invokeTestMethod(Method method, RunNotifier notifier) {
        Object test = null;
        try {
            test = this.createTest();
        }
        catch (InvocationTargetException e) {
            RunNotifierCompatibility.testAborted(notifier, this.methodDescription(method), e.getCause());
            return;
        }
        catch (Exception e) {
            RunNotifierCompatibility.testAborted(notifier, this.methodDescription(method), e);
            return;
        }
        this.createMethodRunner(test, method, notifier).run();
    }

    protected S2TestMethodRunner createMethodRunner(Object test, Method method, RunNotifier notifier) {
        return S2TestClassMethodsRunner.getProvider().createMethodRunner(test, method, notifier, this.methodDescription(method));
    }

    protected String testName(Method method) {
        return method.getName();
    }

    protected Description methodDescription(Method method) {
        return Description.createTestDescription(this.getTestClass(), (String)this.testName(method));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<Method> iter = this.testMethods.iterator();
        while (iter.hasNext()) {
            Method method = iter.next();
            if (filter.shouldRun(this.methodDescription(method))) continue;
            iter.remove();
        }
        if (this.testMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    public void sort(final Sorter sorter) {
        Collections.sort(this.testMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return sorter.compare(S2TestClassMethodsRunner.this.methodDescription(o1), S2TestClassMethodsRunner.this.methodDescription(o2));
            }
        });
    }

    protected Class<?> getTestClass() {
        return this.testClass;
    }

    protected static Provider getProvider() {
        if (provider == null) {
            provider = new DefaultProvider();
        }
        return provider;
    }

    protected static void setProvider(Provider p) {
        provider = p;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultProvider
    implements Provider {
        protected S2TestIntrospector introspector;
        protected Class<? extends S2TestMethodRunner> methodRunnerClass;
        protected Constructor<? extends S2TestMethodRunner> constructor;

        public DefaultProvider() {
            ConventionTestIntrospector conventionIntrospector = new ConventionTestIntrospector();
            conventionIntrospector.init();
            this.introspector = conventionIntrospector;
            this.setTestMethodRunnerClass(S2TestMethodRunner.class);
        }

        @Binding(bindingType=BindingType.MAY)
        public void setTestIntrospector(S2TestIntrospector introspector) {
            this.introspector = introspector;
        }

        @Binding(bindingType=BindingType.MAY)
        public void setTestMethodRunnerClass(Class<? extends S2TestMethodRunner> methodRunnerClass) {
            this.methodRunnerClass = methodRunnerClass;
            this.constructor = ReflectionUtil.getConstructor(methodRunnerClass, Object.class, Method.class, RunNotifier.class, Description.class, S2TestIntrospector.class);
        }

        @Override
        public List<Method> getTestMethods(Class<?> clazz) {
            return this.introspector.getTestMethods(clazz);
        }

        @Override
        public List<Method> getBeforeClassMethods(Class<?> clazz) {
            return this.introspector.getBeforeClassMethods(clazz);
        }

        @Override
        public List<Method> getAfterClassMethods(Class<?> clazz) {
            return this.introspector.getAfterClassMethods(clazz);
        }

        @Override
        public S2TestMethodRunner createMethodRunner(Object test, Method method, RunNotifier notifier, Description description) {
            return ReflectionUtil.newInstance(this.constructor, test, method, notifier, description, this.introspector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Provider {
        public List<Method> getTestMethods(Class<?> var1);

        public List<Method> getBeforeClassMethods(Class<?> var1);

        public List<Method> getAfterClassMethods(Class<?> var1);

        public S2TestMethodRunner createMethodRunner(Object var1, Method var2, RunNotifier var3, Description var4);
    }

    private static class FailedBefore
    extends Exception {
        private static final long serialVersionUID = 1L;

        private FailedBefore() {
        }
    }
}

