/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.internal.PageContextUtil;
import javax.faces.internal.RenderPreparableUtil;
import javax.faces.render.RenderKitFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.seasar.framework.container.servlet.S2ContainerServlet;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.teeda.core.application.TeedaStateManager;
import org.seasar.teeda.core.application.ViewHandlerImpl;
import org.seasar.teeda.core.util.ExternalContextUtil;
import org.seasar.teeda.core.util.PortletExternalContextUtil;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.core.util.ServletExternalContextUtil;
import org.seasar.teeda.extension.exception.JspRuntimeException;
import org.seasar.teeda.extension.html.HtmlSuffix;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;
import org.seasar.teeda.extension.html.PagePersistence;
import org.seasar.teeda.extension.html.PageScopeHandler;
import org.seasar.teeda.extension.html.SubApplicationScopeHandler;
import org.seasar.teeda.extension.html.TagProcessor;
import org.seasar.teeda.extension.html.TagProcessorCache;
import org.seasar.teeda.extension.html.impl.PageScopeHandlerImpl;
import org.seasar.teeda.extension.html.impl.SubApplicationScopeHandlerImpl;
import org.seasar.teeda.extension.jsp.PageContextImpl;

public class HtmlViewHandler
extends ViewHandlerImpl {
    private TagProcessorCache tagProcessorCache;
    private PagePersistence pagePersistence;
    private HtmlSuffix htmlSuffix;
    private TeedaStateManager stateManager;
    private PageDescCache pageDescCache;
    public static final String pageScopeHandler_BINDING = "bindingType=may";
    private PageScopeHandler pageScopeHandler = new PageScopeHandlerImpl();
    public static final String subApplicationScopeHandler_BINDING = "bindingType=may";
    private SubApplicationScopeHandler subApplicationScopeHandler = new SubApplicationScopeHandlerImpl();

    public void setTagProcessorCache(TagProcessorCache tagProcessorCache) {
        this.tagProcessorCache = tagProcessorCache;
    }

    public void setPagePersistence(PagePersistence pagePersistence) {
        this.pagePersistence = pagePersistence;
    }

    public void setHtmlSuffix(HtmlSuffix htmlSuffix) {
        this.htmlSuffix = htmlSuffix;
    }

    public void setStateManager(TeedaStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        this.htmlSuffix.setupSuffix(context, viewId);
        this.setUpRequestForExternalBinding(context, viewId);
        this.tagProcessorCache.updateTagProcessor(viewId);
        return super.restoreView(context, viewId);
    }

    protected void setUpRequestForExternalBinding(FacesContext context, String viewId) {
        ExternalContext external = context.getExternalContext();
        if (viewId.equals(ExternalContextUtil.getViewId((ExternalContext)external))) {
            this.pagePersistence.restore(context, viewId);
        }
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        UIViewRoot viewRoot = super.createView(context, viewId);
        TagProcessor processor = this.tagProcessorCache.getTagProcessor(viewId);
        if (processor == null) {
            return viewRoot;
        }
        HttpServletRequest request = this.prepareRequest(context);
        HttpServletResponse response = this.prepareResponse(context);
        try {
            PageContext pageContext = this.createPageContext(request, response);
            PageContextUtil.setCurrentFacesContextAttribute((PageContext)pageContext, (FacesContext)context);
            PageContextUtil.setCurrentViewRootAttribute((PageContext)pageContext, (UIViewRoot)viewRoot);
            processor.composeComponentTree(context, pageContext, null);
            this.stateManager.saveViewToServer(context, viewRoot);
        }
        catch (JspException e) {
            throw new JspRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return viewRoot;
    }

    public void renderView(FacesContext context, UIViewRoot viewRoot) throws IOException {
        RenderPreparableUtil.encodeBeforeForComponent((FacesContext)context, (UIComponent)viewRoot);
        ExternalContext externalContext = context.getExternalContext();
        String path = ExternalContextUtil.getViewId((ExternalContext)externalContext);
        this.renderView(context, path);
        RenderPreparableUtil.encodeAfterForComponent((FacesContext)context, (UIComponent)viewRoot);
    }

    protected void renderView(FacesContext context, String path) throws IOException {
        HttpServletRequest request = this.prepareRequest(context);
        HttpServletResponse response = this.prepareResponse(context);
        PageContext pageContext = this.createPageContext(request, response);
        TagProcessor tagProcessor = this.tagProcessorCache.getTagProcessor(path);
        PageDesc pageDesc = this.pageDescCache.getPageDesc(path);
        try {
            tagProcessor.process(pageContext, null);
        }
        catch (JspException ex) {
            throw new JspRuntimeException(ex);
        }
        if (!context.getResponseComplete()) {
            this.subApplicationScopeHandler.toScope(pageDesc, context);
            this.pageScopeHandler.toScope(pageDesc, context);
        }
        pageContext.getOut().flush();
    }

    protected Servlet getServlet() {
        return S2ContainerServlet.getInstance();
    }

    protected ServletConfig getServletConfig() {
        return this.getServlet().getServletConfig();
    }

    protected ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    protected PageContext createPageContext(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PageContextImpl pageContext = new PageContextImpl();
        pageContext.initialize(this.getServlet(), (ServletRequest)request, (ServletResponse)response, null);
        return pageContext;
    }

    protected RenderKitFactory getRenderKitFactory() {
        return (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
    }

    protected HttpServletRequest prepareRequest(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (!PortletUtil.isPortlet((FacesContext)context)) {
            return ServletExternalContextUtil.getRequest((ExternalContext)externalContext);
        }
        return PortletExternalContextUtil.wrapByHttpServletRequestWrapper((ExternalContext)externalContext);
    }

    protected HttpServletResponse prepareResponse(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (!PortletUtil.isPortlet((FacesContext)context)) {
            return ServletExternalContextUtil.getResponse((ExternalContext)externalContext);
        }
        return PortletExternalContextUtil.wrapByHttpServletResponseWrapper((ExternalContext)externalContext);
    }

    public PageDescCache getPageDescCache() {
        return this.pageDescCache;
    }

    public void setPageDescCache(PageDescCache pageDescCache) {
        this.pageDescCache = pageDescCache;
    }

    public PageScopeHandler getPageScopeHandler() {
        return this.pageScopeHandler;
    }

    public void setPageScopeHandler(PageScopeHandler pageScopeHandler) {
        this.pageScopeHandler = pageScopeHandler;
    }

    public SubApplicationScopeHandler getSubApplicationScopeHandler() {
        return this.subApplicationScopeHandler;
    }

    public void setSubApplicationScopeHandler(SubApplicationScopeHandler subApplicationScopeHandler) {
        this.subApplicationScopeHandler = subApplicationScopeHandler;
    }
}

