/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.helper.impl;

import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.exception.IllegalLayoutPathRuntimeException;
import org.seasar.teeda.extension.helper.PathHelper;

public class PathHelperImpl
implements PathHelper {
    private NamingConvention namingConvention;

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public String fromPageClassToViewRootRelativePath(Class pageClass) {
        AssertionUtil.assertNotNull((String)"pageClass", (Object)pageClass);
        String viewId = this.namingConvention.fromPageClassToPath(pageClass);
        String viewRootPath = this.namingConvention.adjustViewRootPath();
        return StringUtil.trimPrefix((String)viewId, (String)viewRootPath);
    }

    public String fromViewRootRelativePathToViewId(String viewRootRelativePath) {
        AssertionUtil.assertNotNull((String)"viewRootRelativePath", (Object)viewRootRelativePath);
        String viewRootPath = this.namingConvention.getViewRootPath();
        if (!viewRootRelativePath.startsWith("/")) {
            throw new IllegalLayoutPathRuntimeException(viewRootRelativePath, viewRootPath);
        }
        if ("/".equals(viewRootPath)) {
            viewRootPath = "";
        }
        return viewRootPath + viewRootRelativePath;
    }
}

