/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractInputRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class THtmlGridInputTextRenderer
extends AbstractInputRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.GridInputText";
    static final String DISPLAY_NONE = "display:none;";
    static final String EDIT_ON = "Teeda.THtmlGrid.editOn(this);";
    static final String EDIT_OFF = "Teeda.THtmlGrid.editOff(this);";
    static final String GRID_CELL_EDIT_CLASS_NAME = "gridCellEdit";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        if (!(component instanceof HtmlInputText)) {
            throw new ClassCastException(component.getClass().getName());
        }
        this.encodeHtmlGridInputTextEnd(context, component);
    }

    protected void encodeHtmlGridInputTextEnd(FacesContext context, UIComponent gridInputText) throws IOException {
        this.renderStartDiv(context, gridInputText);
        String value = this.getValue(context, gridInputText);
        this.renderSpan(context, gridInputText, value);
        this.renderInput(context, gridInputText);
        this.renderEndDiv(context, gridInputText);
    }

    protected void renderStartDiv(FacesContext context, UIComponent gridInputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", gridInputText);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onclick", (Object)EDIT_ON);
    }

    protected void renderEndDiv(FacesContext context, UIComponent gridInputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("&nbsp;");
        writer.endElement("div");
    }

    protected void renderSpan(FacesContext context, UIComponent gridInputText, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", gridInputText);
        if (value != null) {
            writer.writeText((Object)value, null);
        }
        writer.endElement("span");
    }

    protected String getValue(FacesContext context, UIComponent gridInputText) {
        return ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)gridInputText);
    }

    protected void renderInput(FacesContext context, UIComponent gridInputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String value = this.getValue(context, gridInputText);
        writer.startElement("input", gridInputText);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"type", (Object)"text");
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)gridInputText, (String)this.getIdForRender(context, gridInputText));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"name", (Object)gridInputText.getClientId(context));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onblur", (Object)this.createOnblurAttribute(gridInputText));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"class", (Object)GRID_CELL_EDIT_CLASS_NAME);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)DISPLAY_NONE);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"value", (Object)value);
        this.renderRemain(gridInputText, writer);
        writer.endElement("input");
    }

    private String createOnblurAttribute(UIComponent gridInputText) {
        String blur = (String)gridInputText.getAttributes().get("onblur");
        if (StringUtil.isBlank((String)blur)) {
            return EDIT_OFF;
        }
        return "Teeda.THtmlGrid.editOff(this); " + blur;
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlGridInputText(context, (HtmlInputText)component);
    }

    protected void decodeHtmlGridInputText(FacesContext context, HtmlInputText gridInputText) {
        this.getDecoder().decode(context, (UIComponent)gridInputText);
    }

    protected void renderRemain(UIComponent component, ResponseWriter writer) throws IOException {
        IgnoreAttribute ignore = this.buildIgnoreComponent();
        this.renderRemainAttributes(component, writer, ignore);
    }

    protected IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = new IgnoreAttribute();
        ignore.addAttributeName("id");
        ignore.addAttributeName("type");
        ignore.addAttributeName("name");
        ignore.addAttributeName("value");
        ignore.addAttributeName("class");
        ignore.addAttributeName("style");
        ignore.addAttributeName("onblur");
        return ignore;
    }
}

