/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Parameterized;
import org.seasar.framework.unit.S2MethodValidator;
import org.seasar.framework.unit.S2TestClassMethodsRunner;
import org.seasar.framework.unit.S2TestClassRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2Parameterized
extends S2TestClassRunner {
    public S2Parameterized(Class<?> klass) throws Exception {
        super(klass, new RunAllParameterMethods(klass));
    }

    @Override
    protected void validate(S2MethodValidator methodValidator) {
        methodValidator.validateStaticMethods();
        methodValidator.validateInstanceMethods();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunAllParameterMethods
    extends MyCompositeRunner {
        private final Class<?> klass;

        public RunAllParameterMethods(Class<?> klass) throws Exception {
            super(klass.getName());
            this.klass = klass;
            int i = 0;
            for (Object each : this.getParametersList()) {
                if (each instanceof Object[]) {
                    super.add(new TestClassRunnerForParameters(klass, (Object[])Object[].class.cast(each), i++));
                    continue;
                }
                throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.klass.getName(), this.getParametersMethod().getName()));
            }
        }

        private Collection<?> getParametersList() throws IllegalAccessException, InvocationTargetException, Exception {
            return (Collection)Collection.class.cast(this.getParametersMethod().invoke(null, new Object[0]));
        }

        private Method getParametersMethod() throws Exception {
            for (Method each : this.klass.getMethods()) {
                Annotation[] annotations;
                if (each.isBridge() || each.isSynthetic() || !Modifier.isStatic(each.getModifiers())) continue;
                for (Annotation annotation : annotations = each.getAnnotations()) {
                    if (annotation.annotationType() != Parameterized.Parameters.class) continue;
                    return each;
                }
            }
            throw new Exception("No public static parameters method on class " + this.getName());
        }

        @Override
        public void run(RunNotifier notifier) {
            new S2TestClassMethodsRunner(this.klass){

                protected void runMethods(RunNotifier notifier) {
                    RunAllParameterMethods.this.runChildren(notifier);
                }
            }.run(notifier);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyCompositeRunner
    extends Runner
    implements Filterable,
    Sortable {
        private final List<Runner> fRunners = new ArrayList<Runner>();
        private final String fName;

        public MyCompositeRunner(String name) {
            this.fName = name;
        }

        public void run(RunNotifier notifier) {
            this.runChildren(notifier);
        }

        protected void runChildren(RunNotifier notifier) {
            for (Runner each : this.fRunners) {
                each.run(notifier);
            }
        }

        public Description getDescription() {
            Description spec = Description.createSuiteDescription((String)this.fName, (Annotation[])new Annotation[0]);
            for (Runner runner : this.fRunners) {
                spec.addChild(runner.getDescription());
            }
            return spec;
        }

        public List<Runner> getRunners() {
            return this.fRunners;
        }

        public void addAll(List<? extends Runner> runners) {
            this.fRunners.addAll(runners);
        }

        public void add(Runner runner) {
            this.fRunners.add(runner);
        }

        public void filter(Filter filter) throws NoTestsRemainException {
            Iterator<Runner> iter = this.fRunners.iterator();
            while (iter.hasNext()) {
                Runner runner = iter.next();
                if (filter.shouldRun(runner.getDescription())) {
                    filter.apply(runner);
                    continue;
                }
                iter.remove();
            }
        }

        protected String getName() {
            return this.fName;
        }

        public void sort(final Sorter sorter) {
            Collections.sort(this.fRunners, new Comparator<Runner>(){

                @Override
                public int compare(Runner o1, Runner o2) {
                    return sorter.compare(o1.getDescription(), o2.getDescription());
                }
            });
            for (Runner each : this.fRunners) {
                sorter.apply(each);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestClassRunnerForParameters
    extends S2TestClassMethodsRunner {
        private final Object[] parameters;
        private final int parameterSetNumber;
        private final Constructor<?> constructor;

        private TestClassRunnerForParameters(Class<?> klass, Object[] parameters, int i) {
            super(klass);
            this.parameters = parameters;
            this.parameterSetNumber = i;
            this.constructor = this.getOnlyConstructor();
        }

        @Override
        protected Object createTest() throws Exception {
            return this.constructor.newInstance(this.parameters);
        }

        @Override
        protected String getName() {
            return String.format("[%s]", this.parameterSetNumber);
        }

        @Override
        protected String testName(Method method) {
            return String.format("%s[%s]", method.getName(), this.parameterSetNumber);
        }

        private Constructor<?> getOnlyConstructor() {
            Constructor<?>[] constructors = this.getTestClass().getConstructors();
            Assert.assertEquals((long)1L, (long)constructors.length);
            return constructors[0];
        }

        @Override
        public void run(RunNotifier notifier) {
            this.runMethods(notifier);
        }
    }
}

