/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.extension.httpsession.S2HttpServletRequestWrapper;
import org.seasar.extension.httpsession.S2HttpServletResponseWrapper;
import org.seasar.extension.httpsession.S2HttpSession;
import org.seasar.extension.httpsession.SessionIdUtil;
import org.seasar.extension.httpsession.SessionState;
import org.seasar.extension.httpsession.SessionStateManager;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.StringUtil;

public class SessionFilter
implements Filter {
    public static final String INIT_PARAM_COOKIE_NAME = "cookieName";
    public static final String INIT_PARAM_COOKIE_MAX_AGE = "cookieMaxAge";
    public static final String INIT_PARAM_COOKIE_PATH = "cookiePath";
    public static final String INIT_PARAM_COOKIE_SECURE = "cookieSecure";
    private SessionStateManager sessionStateManager;

    public void init(FilterConfig config) throws ServletException {
        String cookieSecure;
        String cookiePath;
        String cookieMaxAge;
        String cookieName = config.getInitParameter(INIT_PARAM_COOKIE_NAME);
        if (StringUtil.isNotEmpty((String)cookieName)) {
            SessionIdUtil.cookieName = cookieName;
        }
        if (StringUtil.isNotEmpty((String)(cookieMaxAge = config.getInitParameter(INIT_PARAM_COOKIE_MAX_AGE)))) {
            SessionIdUtil.cookieMaxAge = Integer.parseInt(cookieMaxAge);
        }
        if (StringUtil.isNotEmpty((String)(cookiePath = config.getInitParameter(INIT_PARAM_COOKIE_PATH)))) {
            SessionIdUtil.cookiePath = cookiePath;
        }
        if (StringUtil.isNotEmpty((String)(cookieSecure = config.getInitParameter(INIT_PARAM_COOKIE_SECURE)))) {
            SessionIdUtil.cookieSecure = BooleanConversionUtil.toBoolean((Object)cookieSecure);
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SessionStateManager ssm = this.getSessionStateManager();
        S2HttpServletRequestWrapper requestWrapper = new S2HttpServletRequestWrapper((HttpServletRequest)request, ssm);
        S2HttpServletResponseWrapper responseWrapper = new S2HttpServletResponseWrapper((HttpServletResponse)response, requestWrapper, this.sessionStateManager);
        SessionIdUtil.writeCookie((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper, requestWrapper.getSessionId());
        try {
            SessionState sessionState;
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            Object var8_7 = null;
            S2HttpSession session = requestWrapper.getS2HttpSession();
            if (session != null && (sessionState = session.getSessionState()) != null) {
                ssm.updateState(session.getId(), sessionState);
            }
        }
        catch (Throwable throwable) {
            SessionState sessionState;
            Object var8_8 = null;
            S2HttpSession session = requestWrapper.getS2HttpSession();
            if (session != null && (sessionState = session.getSessionState()) != null) {
                ssm.updateState(session.getId(), sessionState);
            }
            throw throwable;
        }
    }

    protected SessionStateManager getSessionStateManager() {
        if (this.sessionStateManager == null) {
            S2Container container = SingletonS2ContainerFactory.getContainer();
            this.sessionStateManager = (SessionStateManager)container.getComponent((Object)SessionStateManager.class);
        }
        return this.sessionStateManager;
    }
}

