/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.internal.ConverterResource;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.extension.annotation.handler.ConverterAnnotationHandler;

public abstract class AbstractConverterAnnotationHandler
implements ConverterAnnotationHandler {
    private Map expressionsMap = new HashMap();

    public void registerConverter(String componentName, String propertyName, String converterName, Map properties) {
        String expression = BindingUtil.getExpression((String)componentName, (String)propertyName);
        ConverterResource.addConverter((String)expression, (String)converterName, (Map)properties);
        HashSet<String> expressions = (HashSet<String>)this.expressionsMap.get(componentName);
        if (expressions == null) {
            expressions = new HashSet<String>();
            this.expressionsMap.put(componentName, expressions);
        }
        expressions.add(expression);
    }

    public void removeConverters(String componentName) {
        Set expressions = (Set)this.expressionsMap.get(componentName);
        if (expressions == null) {
            return;
        }
        Iterator i = expressions.iterator();
        while (i.hasNext()) {
            String expression = (String)i.next();
            ConverterResource.removeConverter((String)expression);
        }
        this.expressionsMap.remove(componentName);
    }

    public void removeAll() {
        Iterator i = this.expressionsMap.keySet().iterator();
        while (i.hasNext()) {
            String componentName = (String)i.next();
            this.removeConverters(componentName);
        }
    }

    public int getExpressionSize(String componentName) {
        Set expressions = (Set)this.expressionsMap.get(componentName);
        if (expressions == null) {
            return 0;
        }
        return expressions.size();
    }

    protected S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}

