/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.SelectItemsIterator;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.seasar.framework.util.ArrayIterator;
import org.seasar.teeda.core.render.html.HtmlSelectOneRadioRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlSelectOneRadio;

public class THtmlSelectOneRadioRenderer
extends HtmlSelectOneRadioRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.SelectOne";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlSelectOneRadio";

    public THtmlSelectOneRadioRenderer() {
        this.addIgnoreAttributeName("col");
        this.addIgnoreAttributeName("pageName");
        this.addIgnoreAttributeName("labelName");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        if (this.isPageDirectionLayout(component)) {
            super.encodeEnd(context, component);
            return;
        }
        this.encodeTHtmlSelectOneRadio(context, component);
    }

    protected void encodeTHtmlSelectOneRadio(FacesContext context, UIComponent component) throws IOException {
        THtmlSelectOneRadio radio;
        Integer col;
        SelectItemsIterator it = new SelectItemsIterator(component);
        if (!it.hasNext()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean noneLayout = this.isNoneLayout(component);
        if (!noneLayout) {
            writer.startElement("table", component);
            String id = this.getIdForRender(context, component);
            RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)component, (String)id);
            RendererUtil.renderAttributes((ResponseWriter)writer, (UIComponent)component, (String[])TABLE_ATTRIBUTES);
            writer.startElement("tr", component);
        }
        int colCount = (col = (radio = (THtmlSelectOneRadio)component).getCol()) != null ? col : 0;
        String[] selectedValues = this.getValuesForRender(context, (UIComponent)radio);
        int i = 1;
        while (it.hasNext()) {
            if (!noneLayout && col != null && i > colCount) {
                writer.endElement("tr");
                writer.startElement("tr", component);
                i = 1;
            }
            SelectItem selectItem = (SelectItem)it.next();
            if (!noneLayout) {
                writer.startElement("td", (UIComponent)radio);
            }
            if (selectItem instanceof SelectItemGroup) {
                SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
                Object[] selectItems = selectItemGroup.getSelectItems();
                ArrayIterator selectItemsIt = new ArrayIterator(selectItems);
                if (!noneLayout) {
                    writer.startElement("table", (UIComponent)radio);
                }
                this.renderSelectItems(context, (UIComponent)radio, writer, (Iterator)selectItemsIt, selectedValues, false, noneLayout);
                if (!noneLayout) {
                    writer.endElement("table");
                }
            } else {
                this.renderSelectItem(context, (UIComponent)radio, writer, selectedValues, selectItem);
            }
            if (!noneLayout) {
                writer.endElement("td");
            }
            ++i;
        }
        if (!noneLayout) {
            writer.endElement("tr");
            writer.endElement("table");
        }
    }
}

