/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.poi.hslf.model.textproperties.AlignmentTextProp;
import org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import org.apache.poi.hslf.model.textproperties.CharFlagsTextProp;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.LittleEndian;

public class StyleTextPropAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 4001L;
    private byte[] reserved;
    private byte[] rawContents;
    private boolean initialised = false;
    private LinkedList paragraphStyles;
    private LinkedList charStyles;
    public static TextProp[] paragraphTextPropTypes = new TextProp[]{new BitMaskTextProp(2, 15, "paragraph_flags", new String[]{"bullet", "bullet.hardfont", "bullet.hardcolor", "bullet.hardsize"}), new TextProp(2, 128, "bullet.char"), new TextProp(2, 16, "bullet.font"), new TextProp(4, 32, "bullet.color"), new TextProp(2, 64, "bullet.size"), new AlignmentTextProp(), new TextProp(2, 1024, "bullet.offset"), new TextProp(2, 512, "para_unknown_2"), new TextProp(2, 256, "text.offset"), new TextProp(2, 4096, "linespacing"), new TextProp(2, 8192, "spacebefore"), new TextProp(2, 16384, "spaceafter"), new TextProp(2, 32768, "para_unknown_4"), new TextProp(2, 65536, "para_unknown_5"), new TextProp(2, 917504, "para_unknown_6"), new TextProp(2, 0x200000, "para_unknown_7")};
    public static TextProp[] characterTextPropTypes = new TextProp[]{new CharFlagsTextProp(), new TextProp(2, 65536, "font.index"), new TextProp(2, 0x200000, "asian_or_complex"), new TextProp(2, 0x400000, "char_unknown_2"), new TextProp(2, 0x800000, "symbol"), new TextProp(2, 131072, "font.size"), new TextProp(4, 262144, "font.color"), new TextProp(2, 524288, "offset"), new TextProp(2, 0x100000, "char_unknown_1"), new TextProp(2, 0x1000000, "char_unknown_3"), new TextProp(2, 0x2000000, "char_unknown_4"), new TextProp(2, 0x4000000, "char_unknown_5"), new TextProp(2, 0x8000000, "char_unknown_6"), new TextProp(2, 0x10000000, "char_unknown_7"), new TextProp(2, 0x20000000, "char_unknown_8"), new TextProp(2, 0x40000000, "char_unknown_9"), new TextProp(2, Integer.MIN_VALUE, "char_unknown_10")};

    public LinkedList getParagraphStyles() {
        return this.paragraphStyles;
    }

    public void setParagraphStyles(LinkedList ps) {
        this.paragraphStyles = ps;
    }

    public LinkedList getCharacterStyles() {
        return this.charStyles;
    }

    public void setCharacterStyles(LinkedList cs) {
        this.charStyles = cs;
    }

    protected StyleTextPropAtom(byte[] source, int start, int len) {
        if (len < 18) {
            len = 18;
            if (source.length - start < 18) {
                throw new RuntimeException("Not enough data to form a StyleTextPropAtom (min size 18 bytes long) - found " + (source.length - start));
            }
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this.rawContents = new byte[len - 8];
        System.arraycopy(source, start + 8, this.rawContents, 0, this.rawContents.length);
        this.reserved = new byte[0];
        this.paragraphStyles = new LinkedList();
        this.charStyles = new LinkedList();
    }

    public StyleTextPropAtom(int parentTextSize) {
        this._header = new byte[8];
        this.rawContents = new byte[0];
        this.reserved = new byte[0];
        LittleEndian.putInt(this._header, 2, (short)_type);
        LittleEndian.putInt(this._header, 4, 10);
        this.paragraphStyles = new LinkedList();
        this.charStyles = new LinkedList();
        TextPropCollection defaultParagraphTextProps = new TextPropCollection(parentTextSize, 0);
        this.paragraphStyles.add(defaultParagraphTextProps);
        TextPropCollection defaultCharacterTextProps = new TextPropCollection(parentTextSize);
        this.charStyles.add(defaultCharacterTextProps);
        this.initialised = true;
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.updateRawContents();
        int newSize = this.rawContents.length + this.reserved.length;
        LittleEndian.putInt(this._header, 4, newSize);
        out.write(this._header);
        out.write(this.rawContents);
        out.write(this.reserved);
    }

    public void setParentTextSize(int size) {
        int pos = 0;
        int textHandled = 0;
        int prsize = size;
        while (pos < this.rawContents.length && textHandled < prsize) {
            int textLen = LittleEndian.getInt(this.rawContents, pos);
            textHandled += textLen;
            short paraIgn = LittleEndian.getShort(this.rawContents, pos += 4);
            int paraFlags = LittleEndian.getInt(this.rawContents, pos += 2);
            TextPropCollection thisCollection = new TextPropCollection(textLen, paraIgn);
            int plSize = thisCollection.buildTextPropList(paraFlags, paragraphTextPropTypes, this.rawContents, pos += 4);
            this.paragraphStyles.add(thisCollection);
            if ((pos += plSize) >= this.rawContents.length || textHandled != size) continue;
            ++prsize;
        }
        if (this.rawContents.length > 0 && textHandled != size + 1) {
            this.logger.log(5, "Problem reading paragraph style runs: textHandled = " + textHandled + ", text.size+1 = " + (size + 1));
        }
        textHandled = 0;
        int chsize = size;
        while (pos < this.rawContents.length && textHandled < chsize) {
            int textLen = LittleEndian.getInt(this.rawContents, pos);
            textHandled += textLen;
            short no_val = -1;
            int charFlags = LittleEndian.getInt(this.rawContents, pos += 4);
            TextPropCollection thisCollection = new TextPropCollection(textLen, no_val);
            int chSize = thisCollection.buildTextPropList(charFlags, characterTextPropTypes, this.rawContents, pos += 4);
            this.charStyles.add(thisCollection);
            if ((pos += chSize) >= this.rawContents.length || textHandled != size) continue;
            ++chsize;
        }
        if (this.rawContents.length > 0 && textHandled != size + 1) {
            this.logger.log(5, "Problem reading character style runs: textHandled = " + textHandled + ", text.size+1 = " + (size + 1));
        }
        if (pos < this.rawContents.length) {
            this.reserved = new byte[this.rawContents.length - pos];
            System.arraycopy(this.rawContents, pos, this.reserved, 0, this.reserved.length);
        }
        this.initialised = true;
    }

    private void updateRawContents() throws IOException {
        TextPropCollection tpc;
        int i;
        if (!this.initialised) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (i = 0; i < this.paragraphStyles.size(); ++i) {
            tpc = (TextPropCollection)this.paragraphStyles.get(i);
            tpc.writeOut(baos);
        }
        for (i = 0; i < this.charStyles.size(); ++i) {
            tpc = (TextPropCollection)this.charStyles.get(i);
            tpc.writeOut(baos);
        }
        this.rawContents = baos.toByteArray();
    }

    public TextPropCollection addParagraphTextPropCollection(int charactersCovered) {
        TextPropCollection tpc = new TextPropCollection(charactersCovered, 0);
        this.paragraphStyles.add(tpc);
        return tpc;
    }

    public TextPropCollection addCharacterTextPropCollection(int charactersCovered) {
        TextPropCollection tpc = new TextPropCollection(charactersCovered);
        this.charStyles.add(tpc);
        return tpc;
    }

    public String toString() {
        TextProp p;
        Iterator it2;
        TextPropCollection pr;
        StringBuffer out = new StringBuffer();
        out.append("Paragraph properties\n");
        Iterator it1 = this.getParagraphStyles().iterator();
        while (it1.hasNext()) {
            pr = (TextPropCollection)it1.next();
            out.append("  chars covered: " + pr.getCharactersCovered() + "\n");
            it2 = pr.getTextPropList().iterator();
            while (it2.hasNext()) {
                p = (TextProp)it2.next();
                out.append("    " + p.getName() + " = " + p.getValue() + "\n");
            }
        }
        out.append("Character properties\n");
        it1 = this.getCharacterStyles().iterator();
        while (it1.hasNext()) {
            pr = (TextPropCollection)it1.next();
            out.append("  chars covered: " + pr.getCharactersCovered() + "\n");
            it2 = pr.getTextPropList().iterator();
            while (it2.hasNext()) {
                p = (TextProp)it2.next();
                out.append("    " + p.getName() + " = " + p.getValue() + "\n");
            }
        }
        return out.toString();
    }
}

