/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.LoopIterator;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlPanelGridRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    public static final String RENDERER_TYPE = "javax.faces.Grid";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlPanelGridRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("headerClass");
        this.ignoreComponent.addAttributeName("footerClass");
        this.ignoreComponent.addAttributeName("columns");
        this.ignoreComponent.addAttributeName("columnClasses");
        this.ignoreComponent.addAttributeName("rowClasses");
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlPanelGridBegin(context, (HtmlPanelGrid)component);
    }

    protected void encodeHtmlPanelGridBegin(FacesContext context, HtmlPanelGrid htmlPanelGrid) throws IOException {
        UIComponent tableFooter;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", htmlPanelGrid);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlPanelGrid, this.getIdForRender(context, htmlPanelGrid));
        this.renderRemainAttributes(htmlPanelGrid, writer, this.ignoreComponent);
        UIComponent tableHeader = this.toNullIfNotRendered(htmlPanelGrid.getFacet("header"));
        if (tableHeader != null) {
            writer.startElement("thead", tableHeader);
            writer.startElement("tr", tableHeader);
            writer.startElement("th", tableHeader);
            RendererUtil.renderAttribute(writer, "colspan", new Integer(this.getColumns(htmlPanelGrid)));
            writer.writeAttribute("scope", "colgroup", null);
            RendererUtil.renderAttribute(writer, "class", htmlPanelGrid.getHeaderClass(), "headerClass");
            this.encodeComponent(context, tableHeader);
            writer.endElement("th");
            this.closeTr(writer);
            writer.endElement("thead");
        }
        if ((tableFooter = this.toNullIfNotRendered(htmlPanelGrid.getFacet("footer"))) != null) {
            writer.startElement("tfoot", tableFooter);
            writer.startElement("tr", tableFooter);
            writer.startElement("td", tableFooter);
            RendererUtil.renderAttribute(writer, "colspan", new Integer(this.getColumns(htmlPanelGrid)));
            RendererUtil.renderAttribute(writer, "class", htmlPanelGrid.getFooterClass(), "footerClass");
            this.encodeComponent(context, tableFooter);
            writer.endElement("td");
            this.closeTr(writer);
            writer.endElement("tfoot");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlPanelGridChildren(context, (HtmlPanelGrid)component);
    }

    protected void encodeHtmlPanelGridChildren(FacesContext context, HtmlPanelGrid htmlPanelGrid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tbody", htmlPanelGrid);
        LoopIterator rowClasses = this.toStyleLoopIterator(htmlPanelGrid.getRowClasses());
        LoopIterator columnClasses = this.toStyleLoopIterator(htmlPanelGrid.getColumnClasses());
        int maxColumns = this.getColumns(htmlPanelGrid);
        boolean initialPosition = false;
        int position = 0;
        boolean trTagOpening = false;
        Iterator itChild = this.getRenderedChildrenIterator(htmlPanelGrid);
        while (itChild.hasNext()) {
            UIComponent child = (UIComponent)itChild.next();
            if (position == 0) {
                this.openTr(writer, htmlPanelGrid, rowClasses, columnClasses);
                trTagOpening = true;
            }
            this.encodeBodyRowColumn(context, child, writer, columnClasses);
            if (maxColumns > ++position) continue;
            position = 0;
            this.closeTr(writer);
            trTagOpening = false;
        }
        if (trTagOpening) {
            this.closeTr(writer);
            trTagOpening = false;
        }
        writer.endElement("tbody");
    }

    private void openTr(ResponseWriter writer, HtmlPanelGrid htmlPanelGrid, LoopIterator rowClasses, LoopIterator columnClasses) throws IOException {
        writer.startElement("tr", htmlPanelGrid);
        if (rowClasses.hasNext()) {
            RendererUtil.renderAttribute(writer, "class", rowClasses.next(), "rowClasses");
        }
        columnClasses.reset();
    }

    private void closeTr(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
    }

    private void encodeBodyRowColumn(FacesContext context, UIComponent component, ResponseWriter writer, Iterator columnClasses) throws IOException {
        writer.startElement("td", component);
        if (columnClasses.hasNext()) {
            RendererUtil.renderAttribute(writer, "class", columnClasses.next(), "columnClasses");
        }
        this.encodeComponent(context, component);
        writer.endElement("td");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlPanelGridEnd(context, (HtmlPanelGrid)component);
    }

    protected void encodeHtmlPanelGridEnd(FacesContext context, HtmlPanelGrid htmlPanelGrid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
    }

    public boolean getRendersChildren() {
        return true;
    }

    private int getColumns(HtmlPanelGrid htmlPanelGrid) {
        int columns = htmlPanelGrid.getColumns();
        if (columns <= 0) {
            columns = 1;
        }
        return columns;
    }
}

