/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.teeda.core.render.AbstractInputRenderer;
import org.seasar.teeda.core.util.HTMLEncodeUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlInputSecretRenderer
extends AbstractInputRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "javax.faces.Secret";
    private final IgnoreAttribute ignoreAttribute = new IgnoreAttribute();

    public HtmlInputSecretRenderer() {
        this.addIgnoreAttributeName("id");
        this.addIgnoreAttributeName("value");
        this.addIgnoreAttributeName("redisplay");
        this.addIgnoreAttributeName("styleClass");
        this.addIgnoreAttributeName("type");
        this.addIgnoreAttributeName("name");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlInputSecretEnd(context, (HtmlInputSecret)component);
    }

    protected void encodeHtmlInputSecretEnd(FacesContext context, HtmlInputSecret htmlInputSecret) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", htmlInputSecret);
        RendererUtil.renderAttribute(writer, "type", (Object)"password");
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlInputSecret, this.getIdForRender(context, htmlInputSecret));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlInputSecret.getClientId(context));
        String value = ValueHolderUtil.getValueForRender(context, htmlInputSecret);
        if (!htmlInputSecret.isRedisplay()) {
            value = "";
        }
        RendererUtil.renderAttribute(writer, "value", (Object)HTMLEncodeUtil.encode(value, true, true));
        this.renderStyleClass(context, htmlInputSecret, writer);
        this.renderRemainAttributes(htmlInputSecret, writer, this.ignoreAttribute);
        writer.endElement("input");
    }

    protected void renderStyleClass(FacesContext context, HtmlInputSecret htmlInputSecret, ResponseWriter writer) throws IOException {
        String styleClass = htmlInputSecret.getStyleClass();
        RendererUtil.renderAttribute(writer, "styleClass", (Object)styleClass);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlInputSecret(context, (HtmlInputSecret)component);
    }

    protected void decodeHtmlInputSecret(FacesContext context, HtmlInputSecret htmlInputSecret) {
        this.getDecoder().decode(context, htmlInputSecret);
    }

    public void addIgnoreAttributeName(String name) {
        this.ignoreAttribute.addAttributeName(name);
    }
}

