/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.seasar.teeda.extension.annotation.handler.RedirectDescAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.TakeOverDescAnnotationHandlerFactory;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.RedirectDesc;
import org.seasar.teeda.extension.html.TakeOverDesc;
import org.seasar.teeda.extension.html.impl.ActionDescUtil;

public class ActionDescImpl
implements ActionDesc {
    private String actionName;
    private Set methodNames;
    private Map takeOverDescs;
    private Map redirectDescs;
    private File file;
    private long lastModified;

    public ActionDescImpl(Class actionClass, String actionName) {
        this(actionClass, actionName, null);
    }

    public ActionDescImpl(Class actionClass, String actionName, File file) {
        this.actionName = actionName;
        this.setup(actionClass);
        if (file != null) {
            this.file = file;
            this.lastModified = file.lastModified();
        }
    }

    public String getActionName() {
        return this.actionName;
    }

    protected void setup(Class actionClass) {
        this.methodNames = ActionDescUtil.getActionMethodNames(actionClass);
        this.takeOverDescs = TakeOverDescAnnotationHandlerFactory.getAnnotationHandler().getTakeOverDescs(this.actionName);
        this.redirectDescs = RedirectDescAnnotationHandlerFactory.getAnnotationHandler().getRedirectDescs(this.actionName);
    }

    public boolean hasMethod(String name) {
        return this.methodNames.contains(name);
    }

    public boolean isModified() {
        if (this.file == null) {
            return false;
        }
        if (!this.file.exists()) {
            return true;
        }
        return this.file.lastModified() != this.lastModified;
    }

    public TakeOverDesc getTakeOverDesc(String methodName) {
        if (!this.hasTakeOverDesc(methodName)) {
            throw new IllegalArgumentException(methodName);
        }
        return (TakeOverDesc)this.takeOverDescs.get(methodName);
    }

    public boolean hasTakeOverDesc(String methodName) {
        return this.takeOverDescs.containsKey(methodName);
    }

    public boolean hasRedirectDesc(String methodName) {
        return this.redirectDescs.containsKey(methodName);
    }

    public RedirectDesc getRedirectDesc(String methodName) {
        if (!this.hasRedirectDesc(methodName)) {
            throw new IllegalArgumentException(methodName);
        }
        return (RedirectDesc)this.redirectDescs.get(methodName);
    }
}

