/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class InputRadioFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "inputRadio";

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (pageDesc == null) {
            return false;
        }
        String tagName = elementNode.getTagName();
        if (!"span".equalsIgnoreCase(tagName) && !"div".equalsIgnoreCase(tagName)) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (!pageDesc.hasProperty(id)) {
            return false;
        }
        return this.hasRadioNode(id, elementNode);
    }

    protected boolean hasRadioNode(String id, ElementNode elementNode) {
        for (int i = 0; i < elementNode.getChildSize(); ++i) {
            String name;
            HtmlNode child = elementNode.getChild(i);
            if (!(child instanceof ElementNode)) continue;
            ElementNode node = (ElementNode)child;
            String childTagName = node.getTagName();
            if ("input".equalsIgnoreCase(childTagName) && "radio".equalsIgnoreCase(node.getProperty("type")) && id.equals(name = node.getProperty("name"))) {
                return true;
            }
            if (!this.hasRadioNode(id, node)) continue;
            return true;
        }
        return false;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc != null) {
            properties.put("value", this.getBindingExpression(pageDesc.getPageName(), elementNode.getId()));
        }
    }
}

