/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.seasar.util.collection.EnumerationIterator;
import org.seasar.util.io.CloseableUtil;
import org.seasar.util.io.FileUtil;
import org.seasar.util.io.InputStreamUtil;
import org.seasar.util.io.ResourceHandler;
import org.seasar.util.jar.JarFileUtil;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.zip.ZipInputStreamUtil;

public abstract class ResourceTraversalUtil {
    public static void forEach(File rootDir, ResourceHandler handler) {
        AssertionUtil.assertArgumentNotNull("rootDir", rootDir);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        ResourceTraversalUtil.forEach(rootDir, null, handler);
    }

    public static void forEach(File rootDir, String baseDirectory, ResourceHandler handler) {
        AssertionUtil.assertArgumentNotNull("rootDir", rootDir);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        File baseDir = ResourceTraversalUtil.getBaseDir(rootDir, baseDirectory);
        if (baseDir.exists()) {
            ResourceTraversalUtil.traverseFileSystem(rootDir, baseDir, handler);
        }
    }

    public static void forEach(JarFile jarFile, ResourceHandler handler) {
        AssertionUtil.assertArgumentNotNull("jarFile", jarFile);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        ResourceTraversalUtil.forEach(jarFile, "", handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forEach(JarFile jarFile, String prefix, ResourceHandler handler) {
        AssertionUtil.assertArgumentNotNull("jarFile", jarFile);
        AssertionUtil.assertArgumentNotNull("prefix", prefix);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        int pos = prefix.length();
        for (JarEntry entry : EnumerationIterator.iterable(jarFile.entries())) {
            String entryName;
            if (entry.isDirectory() || !(entryName = entry.getName().replace('\\', '/')).startsWith(prefix)) continue;
            InputStream is = JarFileUtil.getInputStream(jarFile, entry);
            try {
                handler.processResource(entryName.substring(pos), is);
            }
            finally {
                CloseableUtil.close(is);
            }
        }
    }

    public static void forEach(ZipInputStream zipInputStream, ResourceHandler handler) {
        AssertionUtil.assertArgumentNotNull("zipInputStream", zipInputStream);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        ResourceTraversalUtil.forEach(zipInputStream, "", handler);
    }

    public static void forEach(final ZipInputStream zipInputStream, String prefix, ResourceHandler handler) {
        AssertionUtil.assertArgumentNotNull("zipInputStream", zipInputStream);
        AssertionUtil.assertArgumentNotNull("prefix", prefix);
        AssertionUtil.assertArgumentNotNull("handler", handler);
        int pos = prefix.length();
        ZipEntry entry = null;
        while ((entry = ZipInputStreamUtil.getNextEntry(zipInputStream)) != null) {
            String entryName;
            if (entry.isDirectory() || !(entryName = entry.getName().replace('\\', '/')).startsWith(prefix)) continue;
            handler.processResource(entryName.substring(pos), new FilterInputStream(zipInputStream){

                @Override
                public void close() throws IOException {
                    ZipInputStreamUtil.closeEntry(zipInputStream);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void traverseFileSystem(File rootDir, File baseDir, ResourceHandler handler) {
        for (File file : baseDir.listFiles()) {
            if (file.isDirectory()) {
                ResourceTraversalUtil.traverseFileSystem(rootDir, file, handler);
                continue;
            }
            int pos = FileUtil.getCanonicalPath(rootDir).length();
            String filePath = FileUtil.getCanonicalPath(file);
            String resourcePath = filePath.substring(pos + 1).replace('\\', '/');
            FileInputStream is = InputStreamUtil.create(file);
            try {
                handler.processResource(resourcePath, is);
            }
            finally {
                CloseableUtil.close(is);
            }
        }
    }

    protected static File getBaseDir(File rootDir, String baseDirectory) {
        AssertionUtil.assertArgumentNotNull("rootDir", rootDir);
        File baseDir = rootDir;
        if (baseDirectory != null) {
            for (String name : baseDirectory.split("/")) {
                baseDir = new File(baseDir, name);
            }
        }
        return baseDir;
    }
}

